/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.authentication.formopenid.Activator;
import org.eclipse.orion.server.authentication.formopenid.FormOpenIdAuthenticationService;
import org.eclipse.orion.server.authentication.formopenid.internal.OpendIdProviderDescription;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginFormServlet
extends HttpServlet {
    private static final long serialVersionUID = -1941415021420599704L;
    private List<OpendIdProviderDescription> defaultOpenids;
    private FormOpenIdAuthenticationService authenticationService;

    public LoginFormServlet(FormOpenIdAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    private OpendIdProviderDescription getOpenidProviderFromJson(JSONObject json) throws JSONException {
        OpendIdProviderDescription provider = new OpendIdProviderDescription();
        String url = json.getString("url");
        provider.setAuthSite(url);
        try {
            String name = json.getString("name");
            provider.setName(name);
        }
        catch (JSONException jSONException) {}
        try {
            String image = json.getString("image");
            provider.setImage(image);
        }
        catch (JSONException jSONException) {}
        return provider;
    }

    private List<OpendIdProviderDescription> getSupportedOpenIdProviders(String openids) throws JSONException {
        ArrayList<OpendIdProviderDescription> opendIdProviders = new ArrayList<OpendIdProviderDescription>();
        JSONArray openidArray = new JSONArray(openids);
        int i = 0;
        while (i < openidArray.length()) {
            JSONObject jsonProvider = openidArray.getJSONObject(i);
            try {
                opendIdProviders.add(this.getOpenidProviderFromJson(jsonProvider));
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", "Cannot load OpenId provider, invalid entry " + jsonProvider + " Attribute \"ulr\" is mandatory", (Throwable)e));
            }
            ++i;
        }
        return opendIdProviders;
    }

    private List<OpendIdProviderDescription> getDefaultOpenIdProviders() {
        try {
            if (this.defaultOpenids == null) {
                this.defaultOpenids = this.getSupportedOpenIdProviders(this.getFileContents("/openids/DefaultOpenIdProviders.json"));
            }
        }
        catch (Exception e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", "Cannot load default openid list, JSON format expected", (Throwable)e));
            return new ArrayList<OpendIdProviderDescription>();
        }
        return this.defaultOpenids;
    }

    private String getConfiguredOpenIds() {
        return (String)(this.authenticationService.getDefaultAuthenticationProperties() == null ? null : this.authenticationService.getDefaultAuthenticationProperties().get("openids"));
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        if (!resp.isCommitted()) {
            List<OpendIdProviderDescription> openidProviders;
            String customOpenids;
            String string = customOpenids = req.getAttribute("openids") == null ? this.getConfiguredOpenIds() : (String)req.getAttribute("openids");
            if (customOpenids == null || customOpenids.trim().length() == 0) {
                openidProviders = this.getDefaultOpenIdProviders();
            } else {
                try {
                    openidProviders = this.getSupportedOpenIdProviders(customOpenids);
                }
                catch (JSONException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", "Cannot load openid list, JSON format expected", (Throwable)e));
                    openidProviders = this.getDefaultOpenIdProviders();
                }
            }
            String versionString = req.getHeader("Orion-Version");
            Version version = versionString == null ? null : new Version(versionString);
            String xRequestedWith = req.getHeader("X-Requested-With");
            if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
                this.writeHtmlResponse(req, resp, openidProviders);
            } else {
                this.writeJavaScriptResponse(req, resp, openidProviders);
            }
        }
    }

    private void writeJavaScriptResponse(HttpServletRequest req, HttpServletResponse resp, List<OpendIdProviderDescription> openids) throws IOException {
        resp.setContentType("text/javascript");
        PrintWriter writer = resp.getWriter();
        writer.print("if(!stylg)\n");
        writer.print("var stylg=document.createElement(\"link\");");
        writer.print("stylg.setAttribute(\"rel\", \"stylesheet\");");
        writer.print("stylg.setAttribute(\"type\", \"text/css\");");
        writer.print("stylg.setAttribute(\"href\", \"");
        writer.print(this.getStyles(req.getParameter("styles")));
        writer.print("\");");
        writer.print("if(!divg)\n");
        writer.print("var divg = document.createElement(\"span\");\n");
        writer.print("divg.innerHTML='");
        writer.print(this.loadJSResponse(req, openids));
        writer.print("setUserStore('");
        writer.print(FormAuthHelper.getDefaultUserAdmin().getStoreName());
        writer.print("');");
        String path = req.getPathInfo();
        if (path.startsWith("/login")) {
            writer.print("login();");
        } else if (path.startsWith("/checkuser")) {
            writer.print("checkUser();");
        }
        writer.flush();
    }

    private String getStyles(String stylesParam) {
        if (stylesParam == null || stylesParam.length() == 0) {
            return "/mixloginstatic/css/defaultLoginWindow.css";
        }
        return stylesParam.replaceAll("'", "\\\\'").replaceAll("\\t+", " ").replaceAll("\n", "");
    }

    private String loadJSResponse(HttpServletRequest req, List<OpendIdProviderDescription> openids) throws IOException {
        StringBuilder sb = new StringBuilder();
        StringBuilder authString = new StringBuilder();
        this.appendFileContentAsJsString(authString, "web/auth.html");
        String authSite = this.replaceNewAccount(authString.toString(), req.getHeader("Referer"), true);
        authSite = this.replaceError(authSite, "");
        authSite = this.replaceOpenidList(authSite, openids, true);
        authSite = this.replaceUserStores(authSite, true);
        sb.append(authSite);
        sb.append("';\n");
        sb.append("var scr = '");
        this.appendFileContentAsJsString(sb, "web/js/xhrAuth.js");
        sb.append("';\n");
        sb.append(this.getFileContents("web/js/loadXhrAuth.js"));
        return sb.toString();
    }

    private String getFileContents(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStream is = Activator.getBundleContext().getBundle().getEntry(filename).openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = "";
        while ((line = br.readLine()) != null) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private String getFileContentAsJsString(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.appendFileContentAsJsString(sb, filename);
        return sb.toString();
    }

    private void appendFileContentAsJsString(StringBuilder sb, String filename) throws IOException {
        InputStream is = Activator.getBundleContext().getBundle().getEntry(filename).openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = "";
        while ((line = br.readLine()) != null) {
            line = line.replaceAll("'", "\\\\'");
            line = line.replaceAll("\\t+", " ");
            sb.append(line);
        }
    }

    private void writeHtmlResponse(HttpServletRequest req, HttpServletResponse response, List<OpendIdProviderDescription> openids) throws IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<meta name=\"copyright\" content=\"Copyright (c) IBM Corporation and others 2010.\" >");
        writer.println("<meta http-equiv=\"Content-Language\" content=\"en-us\">");
        writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">");
        writer.println("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=8\">");
        writer.println("<title>Login Page</title>");
        if (req.getParameter("styles") == null || "".equals(req.getParameter("styles"))) {
            writer.println("<style type=\"text/css\">");
            writer.print("@import \"");
            writer.print("/mixloginstatic/css/defaultLoginWindow.css");
            writer.print("\";");
            writer.println("</style>");
        } else {
            writer.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            writer.print(req.getParameter("styles"));
            writer.print("\">");
        }
        writer.println("<script type=\"text/javascript\"><!--");
        writer.println("function confirm() {}");
        writer.println(this.getFileContents("web/js/htmlAuth.js"));
        writer.println("//--></script>");
        writer.println("</head>");
        writer.print("<body onLoad=\"javascript:setUserStore('");
        writer.print(FormAuthHelper.getDefaultUserAdmin().getStoreName());
        writer.println("');\">");
        String authSite = this.getFileContents("web/auth.html");
        authSite = this.replaceForm(authSite, req.getParameter("redirect"));
        authSite = this.replaceNewAccount(authSite, req.getParameter("redirect") == null ? req.getRequestURI() : req.getParameter("redirect"), false);
        authSite = this.replaceError(authSite, req.getParameter("error"));
        authSite = this.replaceOpenidList(authSite, openids, false);
        authSite = this.replaceUserStores(authSite, false);
        writer.println(authSite);
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
    }

    private String replaceError(String authSite, String error) {
        if (error == null) {
            error = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"errorWin\"");
        if (error.trim().length() == 0) {
            sb.append(" style=\"display: none\"");
        }
        sb.append(">");
        sb.append("<ul id=\"loginError\">");
        sb.append("<li id=\"errorMessage\">");
        sb.append(new String(Base64.decode((byte[])error.getBytes())));
        sb.append("</li></ul>");
        sb.append("</div>");
        return authSite.replaceAll("<!--ERROR-->", sb.toString());
    }

    private String replaceForm(String authSite, String redirect) {
        StringBuilder formBegin = new StringBuilder();
        formBegin.append("<form name=\"AuthForm\" method=post action=\"/login/form");
        if (redirect != null && !redirect.equals("")) {
            formBegin.append("?redirect=");
            formBegin.append(redirect);
        }
        formBegin.append("\">");
        formBegin.append("<input id=\"store\" name=\"store\" type=\"hidden\" value=\"" + FormAuthHelper.getDefaultUserAdmin().getStoreName() + "\">");
        return authSite.replace("<!--form-->", formBegin.toString()).replace("<!--/form-->", "</form>");
    }

    private String replaceCreateUserForm(String authSite, String redirect) {
        StringBuilder formBegin = new StringBuilder();
        formBegin.append("<form name=\"CreateUserForm\" onsubmit=\"return validatePasswords()\" method=post action=\"/users");
        if (redirect != null && !redirect.equals("")) {
            formBegin.append("?redirect=");
            formBegin.append(redirect);
        }
        formBegin.append("\">");
        return authSite.replace("<!--form-->", formBegin.toString()).replace("<!--/form-->", "</form>");
    }

    private String replaceNewAccount(String authSite, String redirect, boolean javascriptResp) throws IOException {
        if (!FormAuthHelper.canAddUsers()) {
            return authSite;
        }
        String newAccountA = javascriptResp ? this.getFileContentAsJsString("web/createUser.html") : this.getFileContents("web/createUser.html");
        Collection stores = FormAuthHelper.getSupportedUserStores();
        String userStore = FormAuthHelper.getDefaultUserAdmin().getStoreName();
        newAccountA = newAccountA.replaceAll("<!--userStore-->", stores.size() < 2 ? "" : userStore);
        newAccountA = newAccountA.replaceAll("<!--userStoreValue-->", userStore);
        if (!javascriptResp) {
            newAccountA = this.replaceCreateUserForm(newAccountA, redirect);
        }
        return authSite.replace("<!--NEW_ACCOUNT_LINK-->", newAccountA);
    }

    private String replaceUserStores(String authSite, boolean isJsResponce) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        Collection stores = FormAuthHelper.getSupportedUserStores();
        if (stores == null || stores.size() < 2) {
            return authSite;
        }
        for (String store : stores) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(" | ");
            }
            if (isJsResponce) {
                sb.append("<a class=\"loginWindowStores\" href=\"javascript:setUserStore(\\\\'");
            } else {
                sb.append("<a class=\"loginWindowStores\" href=\"javascript:setUserStore('");
            }
            sb.append(store);
            if (isJsResponce) {
                sb.append("\\\\')\" id=\"Login_");
            } else {
                sb.append("')\" id=\"Login_");
            }
            sb.append(store);
            sb.append("\">");
            sb.append(store);
            sb.append("</a>");
        }
        return authSite.replaceAll("<!--LOGIN STORES-->", sb.toString());
    }

    private String replaceOpenidList(String authSite, List<OpendIdProviderDescription> openids, boolean javascriptResp) {
        if (openids == null || openids.isEmpty()) {
            return authSite;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"hrloginWindow\"></div>");
        sb.append("<h3 class=\"loginWindow\">Login with: ");
        for (OpendIdProviderDescription openid : openids) {
            sb.append(javascriptResp ? openid.toJsImage() : openid.toHtmlImage());
        }
        sb.append("</h3>");
        return authSite.replace("<!--OpenID list-->", sb.toString());
    }
}

