/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.util.ConcurrentModificationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.orion.internal.server.hosting.HostedSite;
import org.eclipse.orion.internal.server.hosting.SiteHostingConfig;
import org.eclipse.orion.internal.server.servlets.hosting.IHostedSite;
import org.eclipse.orion.internal.server.servlets.hosting.ISiteHostingService;
import org.eclipse.orion.internal.server.servlets.hosting.NoMoreHostsException;
import org.eclipse.orion.internal.server.servlets.hosting.SiteHostingException;
import org.eclipse.orion.internal.server.servlets.site.SiteConfiguration;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;

public class SiteHostingService
implements ISiteHostingService {
    private final SiteHostingConfig config;
    private ConcurrentMap<String, IHostedSite> sites;

    public SiteHostingService(SiteHostingConfig config) {
        this.config = config;
        this.sites = new ConcurrentHashMap<String, IHostedSite>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(SiteConfiguration siteConfig, WebUser user, String editServer) throws SiteHostingException {
        ConcurrentMap<String, IHostedSite> concurrentMap = this.sites;
        synchronized (concurrentMap) {
            if (this.get(siteConfig, user) != null) {
                return;
            }
            String host = this.getNextHost(siteConfig.getHostHint());
            try {
                IHostedSite result = this.sites.putIfAbsent(host, new HostedSite(siteConfig, user, host, editServer));
                if (result != null) {
                    throw new ConcurrentModificationException("Table was modified concurrently");
                }
            }
            catch (Exception e) {
                this.sites.remove(host);
                throw new SiteHostingException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(SiteConfiguration siteConfig, WebUser user) throws SiteHostingException {
        ConcurrentMap<String, IHostedSite> concurrentMap = this.sites;
        synchronized (concurrentMap) {
            IHostedSite site = this.get(siteConfig, user);
            if (site == null) {
                return;
            }
            if (!this.sites.remove(site.getHost(), site)) {
                throw new ConcurrentModificationException("Table was modified concurrently");
            }
        }
    }

    public IHostedSite get(SiteConfiguration siteConfig, WebUser user) {
        String id = siteConfig.getId();
        String userName = user.getName();
        for (IHostedSite site : this.sites.values()) {
            if (!site.getSiteConfigurationId().equals(id) || !site.getUserName().equals(userName)) continue;
            return site;
        }
        return null;
    }

    public boolean isHosted(String host) {
        return this.get(host) != null;
    }

    IHostedSite get(String host) {
        return (IHostedSite)this.sites.get(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextHost(String hint) throws NoMoreHostsException {
        hint = hint == null || hint.equals("") ? "site" : hint;
        String portSuffix = ":" + this.config.getHostingPort();
        ConcurrentMap<String, IHostedSite> concurrentMap = this.sites;
        synchronized (concurrentMap) {
            String host = null;
            for (String value : this.config.getHosts()) {
                int pos = value.lastIndexOf("*");
                if (pos != -1) {
                    String rest = value.substring(pos + 1);
                    String candidate = String.valueOf(hint) + rest + portSuffix;
                    int i = 0;
                    while (this.isHosted(candidate)) {
                        candidate = String.valueOf(hint) + Integer.toString(i) + rest + portSuffix;
                        ++i;
                    }
                    host = candidate;
                    break;
                }
                String candidate = String.valueOf(value) + portSuffix;
                if (this.isHosted(candidate)) continue;
                host = candidate;
                break;
            }
            if (host == null) {
                throw new NoMoreHostsException("No more hosts available");
            }
            return host;
        }
    }
}

