/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace.authorization;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReaderV1;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReaderV2;
import org.json.JSONArray;
import org.json.JSONException;

public abstract class AuthorizationReader {
    static AuthorizationReader readerV1 = new AuthorizationReaderV1();
    static AuthorizationReader readerV2 = new AuthorizationReaderV2();

    public static JSONArray getAuthorizationData(IEclipsePreferences preferences) throws JSONException {
        AuthorizationReader reader;
        int version = preferences.getInt("UserRightsVersion", 1);
        switch (version) {
            case 1: {
                reader = readerV1;
                break;
            }
            case 2: {
                reader = readerV2;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported auth data version: " + version);
            }
        }
        return reader.readAuthorizationInfo(preferences);
    }

    abstract JSONArray readAuthorizationInfo(IEclipsePreferences var1) throws JSONException;
}

