/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.server.core.LogHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TransferResourceDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        Path targetPath = new Path(resource.getPath());
        if (targetPath.segmentCount() <= 1) {
            return;
        }
        String servlet = targetPath.segment(0);
        if (!"file".equals(servlet) && !"workspace".equals(servlet)) {
            return;
        }
        try {
            JSONArray children;
            if ("file".equals(servlet)) {
                this.addTransferLinks(resource, representation);
            }
            if ((children = representation.optJSONArray("Children")) != null) {
                int i = 0;
                while (i < children.length()) {
                    JSONObject child = children.getJSONObject(i);
                    if (child.getBoolean("Directory")) {
                        this.addTransferLinks(resource, child);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void addTransferLinks(URI resource, JSONObject representation) throws URISyntaxException, JSONException {
        URI location = new URI(representation.getString("Location"));
        IPath targetPath = new Path(location.getPath()).removeFirstSegments(1).removeTrailingSeparator();
        IPath path = new Path("/xfer/import").append(targetPath);
        URI link = new URI(resource.getScheme(), resource.getAuthority(), path.toString(), null, null);
        representation.put("ImportLocation", (Object)link);
        path = new Path("/xfer/export").append(targetPath).addFileExtension("zip");
        link = new URI(resource.getScheme(), resource.getAuthority(), path.toString(), null, null);
        representation.put("ExportLocation", (Object)link);
    }
}

