/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.openid.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.openid.Activator;
import org.osgi.framework.Version;

public class OpenIdFormServlet
extends HttpServlet {
    private static final long serialVersionUID = -3291715275586171400L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        if (!resp.isCommitted()) {
            String versionString = req.getHeader("Orion-Version");
            Version version = versionString == null ? null : new Version(versionString);
            String xRequestedWith = req.getHeader("X-Requested-With");
            if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
                this.writeHtmlResponse(req, resp);
            } else {
                this.writeJavaScriptResponse(req, resp);
            }
        }
    }

    private void writeJavaScriptResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/javascript");
        PrintWriter writer = resp.getWriter();
        writer.print("if(!stylg)\n");
        writer.print("var stylg=document.createElement(\"link\");");
        writer.print("stylg.setAttribute(\"rel\", \"stylesheet\");");
        writer.print("stylg.setAttribute(\"type\", \"text/css\");");
        writer.print("stylg.setAttribute(\"href\", \"");
        writer.print(this.getStyles(req.getParameter("styles")));
        writer.print("\");");
        writer.print("if(!divg)\n");
        writer.print("var divg = document.createElement(\"span\");\n");
        writer.print("divg.innerHTML='");
        writer.print(this.loadJSResponse(req));
        String path = req.getPathInfo();
        if (path.startsWith("/login")) {
            writer.print("login();");
        } else if (path.startsWith("/checkuser")) {
            writer.print("checkUser();");
        }
        writer.flush();
    }

    private String getStyles(String stylesParam) {
        if (stylesParam == null || stylesParam.length() == 0) {
            return "/openidstatic/css/defaultLoginWindow.css";
        }
        return stylesParam.replaceAll("'", "\\\\'").replaceAll("\\t+", " ").replaceAll("\n", "");
    }

    private String loadJSResponse(HttpServletRequest req) throws IOException {
        StringBuilder sb = new StringBuilder();
        StringBuilder authSite = new StringBuilder();
        this.appendFileContentAsJsString(authSite, "web/auth.html");
        String authString = this.replaceError(authSite.toString(), "");
        sb.append(authString);
        sb.append("';\n");
        sb.append("var scr = '");
        this.appendFileContentAsJsString(sb, "web/js/xhrAuth.js");
        sb.append("';\n");
        sb.append(this.getFileContents("web/js/loadXhrAuth.js"));
        return sb.toString();
    }

    private String getFileContents(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStream is = Activator.getDefault().getContext().getBundle().getEntry(filename).openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = "";
        while ((line = br.readLine()) != null) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private void appendFileContentAsJsString(StringBuilder sb, String filename) throws IOException {
        InputStream is = Activator.getDefault().getContext().getBundle().getEntry(filename).openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = "";
        while ((line = br.readLine()) != null) {
            line = line.replaceAll("'", "\\\\'");
            line = line.replaceAll("\\t+", " ");
            sb.append(line);
        }
    }

    private void writeHtmlResponse(HttpServletRequest req, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<title>Login Page</title>");
        if (req.getParameter("styles") == null || "".equals(req.getParameter("styles"))) {
            writer.println("<style type=\"text/css\">");
            writer.print("@import \"");
            writer.print("/openidstatic/css/defaultLoginWindow.css");
            writer.print("\";");
            writer.println("</style>");
        } else {
            writer.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            writer.print(req.getParameter("styles"));
            writer.print("\">");
        }
        writer.println("<script type=\"text/javascript\"><!--");
        writer.println("function confirm() {}");
        writer.println(this.getFileContents("web/js/htmlAuth.js"));
        writer.println("//--></script>");
        writer.println("</head>");
        writer.println("<body>");
        String authSite = this.getFileContents("web/auth.html");
        authSite = this.replaceError(authSite, req.getParameter("error"));
        writer.println(authSite);
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
    }

    private String replaceError(String authSite, String error) {
        if (error == null) {
            return authSite;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"errorWin\">");
        sb.append("<ul id=\"loginError\">");
        sb.append("<li id=\"errorMessage\">");
        sb.append(new String(Base64.decode((byte[])error.trim().getBytes())));
        sb.append("</li></ul>");
        sb.append("</div>");
        return authSite.replaceAll("<!--ERROR-->", sb.toString());
    }
}

