/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.server.core.LogHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitUserDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        Path targetPath = new Path(resource.getPath());
        String servlet = targetPath.segment(0);
        if (!"users".equals(servlet)) {
            return;
        }
        try {
            this.addPluginLinks(resource, representation);
            JSONArray children = representation.optJSONArray("users");
            if (children != null) {
                int i = 0;
                while (i < children.length()) {
                    JSONObject child = children.getJSONObject(i);
                    this.addPluginLinks(resource, child);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void addPluginLinks(URI resource, JSONObject representation) throws URISyntaxException, JSONException {
        JSONArray plugins = representation.optJSONArray("Plugins");
        if (plugins != null) {
            JSONObject plugin = new JSONObject();
            URI result = new URI(resource.getScheme(), resource.getUserInfo(), resource.getHost(), resource.getPort(), "/plugins/git/userProfilePlugin.html", null, null);
            plugin.put("Url", (Object)result);
            plugins.put((Object)plugin);
        }
    }
}

