/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerStatus
extends Status {
    private static final String PROP_CODE = "Code";
    private static final String PROP_DETAILED_MESSAGE = "DetailedMessage";
    private static final String PROP_HTTP_CODE = "HttpCode";
    private static final String PROP_MESSAGE = "Message";
    private static final String ERROR_DATA = "ErrorData";
    private static final String PROP_SEVERITY = "Severity";
    private static final String SEVERITY_CANCEL = "Cancel";
    private static final String SEVERITY_ERROR = "Error";
    private static final String SEVERITY_INFO = "Info";
    private static final String SEVERITY_OK = "Ok";
    private static final String SEVERITY_WARNING = "Warning";
    private int httpCode;
    private JSONObject errorData;

    public static ServerStatus convert(IStatus status) {
        int httpCode = 200;
        if (status.getSeverity() == 4 || status.getSeverity() == 8) {
            httpCode = 500;
        }
        return ServerStatus.convert(status, httpCode);
    }

    public static ServerStatus convert(IStatus status, int httpCode) {
        if (status instanceof ServerStatus) {
            return (ServerStatus)status;
        }
        return new ServerStatus(status, httpCode);
    }

    public static ServerStatus fromJSON(String string) throws JSONException {
        JSONObject object = new JSONObject(string);
        int httpCode = object.getInt(PROP_HTTP_CODE);
        int code = object.getInt(PROP_CODE);
        String message = object.getString(PROP_MESSAGE);
        int severity = ServerStatus.fromSeverityString(object.getString(PROP_SEVERITY));
        String detailMessage = object.optString(PROP_DETAILED_MESSAGE, null);
        Exception cause = detailMessage == null ? null : new Exception(detailMessage);
        JSONObject errorData = object.optJSONObject(ERROR_DATA);
        return new ServerStatus((IStatus)new Status(severity, "org.eclipse.orion.server.core", code, message, (Throwable)cause), httpCode, errorData);
    }

    public ServerStatus(int severity, int httpCode, String message, Throwable exception) {
        super(severity, "org.eclipse.orion.server.core", message, exception);
        this.httpCode = httpCode;
    }

    public ServerStatus(int severity, int httpCode, String message, JSONObject errorData, Throwable exception) {
        super(severity, "org.eclipse.orion.server.core", message, exception);
        this.httpCode = httpCode;
        this.errorData = errorData;
    }

    public ServerStatus(IStatus status, int httpCode) {
        super(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
        this.httpCode = httpCode;
    }

    public ServerStatus(IStatus status, int httpCode, JSONObject errorData) {
        super(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
        this.httpCode = httpCode;
        this.errorData = errorData;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    private String getSeverityString() {
        switch (this.getSeverity()) {
            case 4: {
                return SEVERITY_ERROR;
            }
            case 2: {
                return SEVERITY_WARNING;
            }
            case 1: {
                return SEVERITY_INFO;
            }
            case 8: {
                return SEVERITY_CANCEL;
            }
            case 0: {
                return SEVERITY_OK;
            }
        }
        return null;
    }

    private static int fromSeverityString(String s) {
        if (SEVERITY_ERROR.equals(s)) {
            return 4;
        }
        if (SEVERITY_WARNING.equals(s)) {
            return 2;
        }
        if (SEVERITY_INFO.equals(s)) {
            return 1;
        }
        if (SEVERITY_CANCEL.equals(s)) {
            return 8;
        }
        return 0;
    }

    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        try {
            Throwable exception;
            result.put(PROP_HTTP_CODE, this.httpCode);
            result.put(PROP_CODE, this.getCode());
            result.put(PROP_MESSAGE, (Object)this.getMessage());
            result.put(PROP_SEVERITY, (Object)this.getSeverityString());
            if (this.errorData != null) {
                result.put(ERROR_DATA, (Object)this.errorData);
            }
            if ((exception = this.getException()) != null) {
                result.put(PROP_DETAILED_MESSAGE, (Object)exception.getMessage());
            }
        }
        catch (JSONException jSONException) {}
        return result;
    }
}

