/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.tasks;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskInfo {
    private static final String KEY_PERCENT_COMPLETE = "PercentComplete";
    private static final String KEY_ID = "Id";
    private static final String KEY_MESSAGE = "Message";
    private static final String KEY_RUNNING = "Running";
    private static final String KEY_LOCATION = "Location";
    private static final String KEY_RESULT = "Result";
    private final String id;
    private String message = "";
    private int percentComplete = 0;
    private boolean running = true;
    private String resultLocation = null;
    private IStatus result;

    public static TaskInfo fromJSON(String taskString) {
        try {
            JSONObject json = new JSONObject(taskString);
            TaskInfo info = new TaskInfo(json.getString(KEY_ID));
            info.setMessage(json.optString(KEY_MESSAGE, ""));
            info.running = json.optBoolean(KEY_RUNNING, true);
            info.setPercentComplete(json.optInt(KEY_PERCENT_COMPLETE, 0));
            info.resultLocation = json.optString(KEY_LOCATION);
            String resultString = json.optString(KEY_RESULT, null);
            if (resultString != null) {
                info.result = ServerStatus.fromJSON(resultString);
            }
            return info;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public TaskInfo(String id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public String getResultLocation() {
        return this.resultLocation;
    }

    public IStatus getResult() {
        return this.result;
    }

    public String getTaskId() {
        return this.id;
    }

    public boolean isRunning() {
        return this.running;
    }

    public TaskInfo setMessage(String message) {
        this.message = message == null ? "" : message;
        return this;
    }

    public TaskInfo setPercentComplete(int percentComplete) {
        if (percentComplete < 0) {
            percentComplete = 0;
        }
        if (percentComplete > 100) {
            percentComplete = 100;
        }
        this.percentComplete = percentComplete;
        return this;
    }

    public TaskInfo done(IStatus status) {
        this.running = false;
        this.percentComplete = 100;
        this.result = status;
        this.message = status.getMessage();
        return this;
    }

    public TaskInfo setResultLocation(String location) {
        this.resultLocation = location;
        return this;
    }

    public JSONObject toJSON() {
        JSONObject resultObject = new JSONObject();
        try {
            resultObject.put(KEY_RUNNING, this.isRunning());
            resultObject.put(KEY_MESSAGE, (Object)this.getMessage());
            resultObject.put(KEY_ID, (Object)this.getTaskId());
            resultObject.put(KEY_PERCENT_COMPLETE, this.getPercentComplete());
            if (this.resultLocation != null) {
                resultObject.put(KEY_LOCATION, (Object)this.resultLocation);
            }
            if (this.result != null) {
                resultObject.put(KEY_RESULT, (Object)ServerStatus.convert(this.result).toJSON());
            }
        }
        catch (JSONException jSONException) {}
        return resultObject;
    }

    public String toString() {
        return "TaskInfo" + this.toJSON();
    }
}

