/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.search;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.eclipse.orion.internal.server.search.SearchActivator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.servlets.OrionServlet;

public class SearchServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        SolrQuery query = this.buildSolrQuery(req);
        try {
            QueryResponse solrResponse = SearchActivator.getInstance().getSolrServer().query((SolrParams)query);
            this.writeResponse(query, req, resp, solrResponse);
        }
        catch (SolrServerException e) {
            LogHelper.log((Throwable)e);
            resp.sendError(500, e.getMessage());
        }
    }

    private SolrQuery buildSolrQuery(HttpServletRequest req) {
        SolrQuery query = new SolrQuery();
        query.setParam("wt", new String[]{"json"});
        query.setParam("fl", new String[]{"Id,Name,Length,Directory,LastModified,Location"});
        query.setParam("hl", new String[]{"true"});
        String queryString = req.getParameter("q");
        queryString = String.valueOf(queryString) + " AND UserName:" + req.getRemoteUser();
        query.setQuery(queryString);
        return query;
    }

    private void writeResponse(SolrQuery query, HttpServletRequest httpRequest, HttpServletResponse httpResponse, QueryResponse queryResponse) throws IOException {
        SolrCore core = SearchActivator.getInstance().getSolrCore();
        LocalSolrQueryRequest solrRequest = new LocalSolrQueryRequest(core, query.toNamedList());
        SolrQueryResponse solrResponse = new SolrQueryResponse();
        NamedList params = (NamedList)queryResponse.getHeader().get("params");
        params.remove("q");
        params.add("q", (Object)httpRequest.getParameter("q"));
        solrResponse.setAllValues(queryResponse.getResponse());
        QueryResponseWriter writer = core.getQueryResponseWriter("json");
        writer.write((Writer)httpResponse.getWriter(), (SolrQueryRequest)solrRequest, solrResponse);
    }
}

