/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.openid;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class BundleEntryHttpContext
implements HttpContext {
    private Bundle bundle;
    private String bundlePath;

    public BundleEntryHttpContext(Bundle bundle) {
        this.bundle = bundle;
    }

    public BundleEntryHttpContext(Bundle b, String bundlePath) {
        this(b);
        if (bundlePath != null) {
            if (bundlePath.endsWith("/")) {
                bundlePath = bundlePath.substring(0, bundlePath.length() - 1);
            }
            if (bundlePath.length() == 0) {
                bundlePath = null;
            }
        }
        this.bundlePath = bundlePath;
    }

    public String getMimeType(String arg0) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        return true;
    }

    public URL getResource(String resourceName) {
        String file;
        Enumeration entryPaths;
        String path;
        int lastSlash;
        if (this.bundlePath != null) {
            resourceName = String.valueOf(this.bundlePath) + resourceName;
        }
        if ((lastSlash = resourceName.lastIndexOf(47)) == -1) {
            return null;
        }
        if (resourceName.endsWith("/")) {
            resourceName = String.valueOf(resourceName) + "index.html";
        }
        if ((path = resourceName.substring(0, lastSlash)).length() == 0) {
            path = "/";
        }
        if ((entryPaths = this.bundle.findEntries(path, file = resourceName.substring(lastSlash + 1), false)) != null && entryPaths.hasMoreElements()) {
            return (URL)entryPaths.nextElement();
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        Enumeration entryPaths;
        if (this.bundlePath != null) {
            path = String.valueOf(this.bundlePath) + path;
        }
        if ((entryPaths = this.bundle.findEntries(path, null, false)) == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        while (entryPaths.hasMoreElements()) {
            URL entryURL = (URL)entryPaths.nextElement();
            String entryPath = entryURL.getFile();
            if (this.bundlePath == null) {
                result.add(entryPath);
                continue;
            }
            result.add(entryPath.substring(this.bundlePath.length()));
        }
        return result;
    }
}

