/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.core.IAliasRegistry;
import org.eclipse.orion.internal.server.hosting.HostingActivator;
import org.eclipse.orion.internal.server.hosting.NotFoundException;
import org.eclipse.orion.internal.server.hosting.RemoteURLProxyServlet;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.ServletFileStoreHandler;
import org.eclipse.orion.internal.server.servlets.hosting.IHostedSite;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;

public class HostedSiteServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    private static final String WORKSPACE_SERVLET_ALIAS = "/workspace";
    private static final String FILE_SERVLET_ALIAS = "/file";
    private ServletResourceHandler<IFileStore> fileSerializer;
    private final URI rootStoreURI;
    private IAliasRegistry aliasRegistry = Activator.getDefault();

    public HostedSiteServlet() {
        this.rootStoreURI = Activator.getDefault().getRootLocationURI();
        this.fileSerializer = new ServletFileStoreHandler(this.rootStoreURI, this.getStatusHandler());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String pathInfoString = req.getPathInfo();
        String queryString = req.getQueryString();
        Path pathInfo = new Path(null, pathInfoString == null ? "" : pathInfoString);
        if (pathInfo.segmentCount() > 0) {
            String hostedHost = pathInfo.segment(0);
            IHostedSite site = HostingActivator.getDefault().getHostingService().get(hostedHost);
            if (site != null) {
                URI[] mappedPaths;
                IPath path = pathInfo.removeFirstSegments(1).makeAbsolute();
                try {
                    mappedPaths = this.getMapped(site, path, queryString);
                }
                catch (URISyntaxException e) {
                    this.handleException(resp, (IStatus)new ServerStatus(4, 400, "Could not create target URI\t", (Throwable)e));
                    return;
                }
                if (mappedPaths != null) {
                    this.serve(req, resp, site, mappedPaths);
                } else {
                    this.handleException(resp, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"No mappings matched {0}", (Object)path), null));
                }
            } else {
                String msg = NLS.bind((String)"Hosted site {0} not found", (Object)hostedHost);
                this.handleException(resp, (IStatus)new ServerStatus(4, 404, msg, null));
            }
        } else {
            super.doGet(req, resp);
        }
    }

    private URI[] getMapped(IHostedSite site, IPath pathInfo, String queryString) throws URISyntaxException {
        Map map = site.getMappings();
        IPath originalPath = pathInfo;
        IPath path = originalPath.removeTrailingSeparator();
        List base = null;
        String rest = null;
        int count = path.segmentCount();
        int i = 0;
        while (i <= count) {
            base = (List)map.get(path.toString());
            if (base != null) {
                rest = originalPath.removeFirstSegments(count - i).toString();
                break;
            }
            path = path.removeLastSegments(1);
            ++i;
        }
        if (base != null) {
            URI[] result = new URI[base.size()];
            int i2 = 0;
            while (i2 < result.length) {
                URI uri = rest.equals("") ? new URI((String)base.get(i2)) : URIUtil.append((URI)new URI((String)base.get(i2)), (String)rest);
                result[i2] = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), queryString, uri.getFragment());
                ++i2;
            }
            return result;
        }
        return null;
    }

    private void serve(HttpServletRequest req, HttpServletResponse resp, IHostedSite site, URI[] mappedPaths) throws ServletException, IOException {
        if (mappedPaths[0].getScheme() == null) {
            if ("GET".equals(req.getMethod())) {
                int i = 0;
                while (i < mappedPaths.length) {
                    boolean failEarlyOn404;
                    boolean bl = failEarlyOn404 = i + 1 < mappedPaths.length;
                    if (this.serveOrionFile(req, resp, site, (IPath)new Path(mappedPaths[i].getPath()), failEarlyOn404)) {
                        return;
                    }
                    ++i;
                }
            } else {
                String message = "Only GET method is supported for workspace paths";
                this.handleException(resp, (IStatus)new ServerStatus(4, 405, NLS.bind((String)message, (Object[])mappedPaths), null));
            }
        } else {
            this.proxyRemotePath(req, (HttpServletResponse)new LocationHeaderServletResponseWrapper(req, resp, site), mappedPaths);
        }
    }

    private boolean serveOrionFile(HttpServletRequest req, HttpServletResponse resp, IHostedSite site, IPath path, boolean failEarlyOn404) throws ServletException {
        String userName = site.getUserName();
        String workspaceId = site.getWorkspaceId();
        String workspaceUri = "/workspace/" + workspaceId;
        boolean allow = false;
        try {
            if (AuthorizationService.checkRights((String)userName, (String)workspaceUri, (String)"GET")) {
                allow = true;
            }
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
        if (allow) {
            String pathInfo = path.toString();
            Path filePath = pathInfo == null ? Path.ROOT : new Path(pathInfo);
            IFileStore file = this.tempGetFileStore((IPath)filePath);
            if (file == null || !file.fetchInfo().exists()) {
                if (failEarlyOn404) {
                    return false;
                }
                this.handleException(resp, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"File not found: {0}", (Object)filePath), null));
            }
            this.fileSerializer.handleRequest(req, resp, (Object)file);
            if (file != null) {
                this.addEditHeaders(resp, site, path);
                this.addContentTypeHeader(resp, path);
            }
        } else {
            String msg = NLS.bind((String)"No rights to access {0}", (Object)workspaceUri);
            this.handleException(resp, (IStatus)new ServerStatus(4, 403, msg, null));
        }
        return true;
    }

    private void addEditHeaders(HttpServletResponse resp, IHostedSite site, IPath path) {
        resp.addHeader("X-Edit-Server", String.valueOf(site.getEditServerUrl()) + "/edit/edit.html#");
        resp.addHeader("X-Edit-Token", FILE_SERVLET_ALIAS + path.toString());
    }

    private void addContentTypeHeader(HttpServletResponse resp, IPath path) {
        String mimeType = this.getServletContext().getMimeType(path.lastSegment());
        if (mimeType != null) {
            resp.addHeader("Content-Type", mimeType);
        }
    }

    protected IFileStore tempGetFileStore(IPath path) {
        URI alias;
        if (path.segmentCount() > 0 && (alias = this.aliasRegistry.lookupAlias(path.segment(0))) != null) {
            try {
                return EFS.getStore((URI)alias).getFileStore(path.removeFirstSegments(1));
            }
            catch (CoreException e) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.hosting", 1, "An error occured when getting file store for path '" + path + "' and alias '" + alias + '\'', (Throwable)e));
            }
        }
        try {
            return EFS.getStore((URI)this.rootStoreURI).getFileStore(path);
        }
        catch (CoreException e) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.hosting", 1, "An error occured when getting file store for path '" + path + "' and root '" + this.rootStoreURI + '\'', (Throwable)e));
            return null;
        }
    }

    private void proxyRemotePath(HttpServletRequest req, HttpServletResponse resp, URI[] mappedPaths) throws IOException, ServletException, UnknownHostException {
        try {
            URL[] mappedURLs = new URL[mappedPaths.length];
            int i = 0;
            while (i < mappedPaths.length) {
                mappedURLs[i] = new URL(mappedPaths[i].toString());
                ++i;
            }
            this.proxyRemoteUrl(req, resp, mappedURLs);
        }
        catch (MalformedURLException e) {
            String message = NLS.bind((String)"Malformed remote URL: {0}", (Object)mappedPaths.toString());
            this.handleException(resp, (IStatus)new ServerStatus(4, 404, message, (Throwable)e));
            return;
        }
        catch (UnknownHostException e) {
            String message = NLS.bind((String)"Unknown host {0}", (Object)e.getMessage());
            this.handleException(resp, (IStatus)new ServerStatus(4, 404, message, (Throwable)e));
        }
        catch (Exception e) {
            String message = NLS.bind((String)"An error occurred while retrieving {0}", (Object)mappedPaths.toString());
            this.handleException(resp, (IStatus)new ServerStatus(4, 500, message, (Throwable)e));
        }
    }

    private void proxyRemoteUrl(HttpServletRequest req, HttpServletResponse resp, URL[] mappedURLs) throws IOException, ServletException, UnknownHostException {
        int i = 0;
        while (i < mappedURLs.length) {
            boolean failEarlyOn404 = i + 1 < mappedURLs.length;
            RemoteURLProxyServlet proxy = new RemoteURLProxyServlet(mappedURLs[i], failEarlyOn404);
            proxy.init(this.getServletConfig());
            try {
                this.traceRequest(req);
                try {
                    proxy.service((ServletRequest)req, (ServletResponse)resp);
                }
                catch (NotFoundException notFoundException) {}
            }
            finally {
                proxy.destroy();
            }
            ++i;
        }
    }

    static class LocationHeaderServletResponseWrapper
    extends HttpServletResponseWrapper {
        private static final String LOCATION = "Location";
        private HttpServletRequest request;
        private IHostedSite site;

        public LocationHeaderServletResponseWrapper(HttpServletRequest request, HttpServletResponse response, IHostedSite site) {
            super(response);
            this.request = request;
            this.site = site;
        }

        private String mapLocation(String location) {
            Map mappings = this.site.getMappings();
            String bestMatch = "";
            String prefix = null;
            for (Map.Entry entry : mappings.entrySet()) {
                List candidates = (List)entry.getValue();
                for (String candidate : candidates) {
                    if (!location.startsWith(candidate) || candidate.length() <= bestMatch.length()) continue;
                    bestMatch = candidate;
                    prefix = (String)entry.getKey();
                }
            }
            if (prefix != null) {
                String reverseMappedPath = String.valueOf(prefix) + location.substring(bestMatch.length());
                try {
                    URI pathlessRequestURI = new URI(this.request.getScheme(), null, this.request.getServerName(), this.request.getServerPort(), null, null, null);
                    return String.valueOf(pathlessRequestURI.toString()) + reverseMappedPath;
                }
                catch (URISyntaxException t) {
                    System.err.println(t);
                }
            }
            return location;
        }

        public void addHeader(String name, String value) {
            if (name.equals(LOCATION)) {
                String newLocation = this.mapLocation(value.trim());
                super.addHeader(name, newLocation);
            } else {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (name.equals(LOCATION)) {
                String newLocation = this.mapLocation(value.trim());
                super.setHeader(name, newLocation);
            } else {
                super.setHeader(name, value);
            }
        }
    }
}

