/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.tasks;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.server.core.LogHelper;

public class TaskStore {
    private final File root;

    public TaskStore(File root) {
        this.root = root;
    }

    public String readTask(String id) {
        File taskFile = new File(this.root, id);
        if (!taskFile.exists()) {
            return null;
        }
        try {
            FileReader reader = new FileReader(taskFile);
            StringWriter writer = new StringWriter();
            IOUtilities.pipe(reader, writer, true, false);
            return writer.toString();
        }
        catch (IOException e) {
            LogHelper.log(e);
            return null;
        }
    }

    public void writeTask(String id, String representation) {
        this.root.mkdirs();
        try {
            File taskFile = new File(this.root, id);
            FileWriter writer = new FileWriter(taskFile);
            StringReader reader = new StringReader(representation);
            IOUtilities.pipe(reader, writer, true, true);
        }
        catch (IOException e) {
            LogHelper.log(e);
        }
    }
}

