/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.user.securestorage;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.internal.server.user.securestorage.Activator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.useradmin.EmptyAuthorization;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.eclipse.orion.server.useradmin.WebIdeAuthorization;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.useradmin.Authorization;
import org.osgi.service.useradmin.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureStorageCredentialsService
implements IOrionCredentialsService {
    static final String ORION_SERVER_NODE = "org.eclipse.orion.server";
    static final String USERS = "users";
    static final String USER_LOGIN = "login";
    static final String USER_NAME = "name";
    static final String USER_PASSWORD = "password";
    static final String USER_ROLES = "roles";
    static final String USER_ROLE_NAME = "name";
    static final String ADMIN_LOGIN_VALUE = "admin";
    static final String ADMIN_NAME_VALUE = "Administrator";
    private ISecurePreferences storage;
    private Map<String, org.eclipse.orion.server.useradmin.Role> roles = new HashMap<String, org.eclipse.orion.server.useradmin.Role>();

    public SecureStorageCredentialsService() {
        this.initSecurePreferences();
        this.initStorage();
    }

    private void initStorage() {
        String adminDefaultPassword = PreferenceHelper.getString((String)"orion.auth.admin.default.password");
        if (adminDefaultPassword != null && this.getUser(USER_LOGIN, ADMIN_LOGIN_VALUE) == null) {
            this.createUser(new User(ADMIN_LOGIN_VALUE, ADMIN_NAME_VALUE, adminDefaultPassword));
        }
        try {
            AuthorizationService.addUserRight((String)ADMIN_LOGIN_VALUE, (String)"/users");
            AuthorizationService.addUserRight((String)ADMIN_LOGIN_VALUE, (String)"/users/*");
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        String[] stringArray = new String[]{ADMIN_LOGIN_VALUE, "user", "quest"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            this.roles.put(role, new org.eclipse.orion.server.useradmin.Role(role, 0));
            ++n2;
        }
    }

    private void initSecurePreferences() {
        URL location = this.getStorageLocation();
        if (location != null) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("org.eclipse.equinox.security.storage.promptUser", Boolean.FALSE);
            String password = System.getProperty("orion.storage.password", "");
            options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec(password.toCharArray()));
            try {
                this.storage = SecurePreferencesFactory.open((URL)location, options);
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", "Error initializing user storage location", (Throwable)e));
            }
        } else {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.user.securestorage", "No instance location set. Storing user data in user home directory"));
        }
        if (this.storage == null) {
            this.storage = SecurePreferencesFactory.getDefault().node(ORION_SERVER_NODE);
        }
    }

    private URL getStorageLocation() {
        Collection refs;
        BundleContext context = Activator.getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            return null;
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location != null) {
                URL uRL = location.getDataArea("org.eclipse.orion.server.user.securestorage/user_store");
                return uRL;
            }
        }
        catch (IOException e) {
            LogHelper.log((Throwable)e);
        }
        finally {
            context.ungetService(ref);
        }
        return null;
    }

    public org.eclipse.orion.server.useradmin.Role createRole(String name, int type) {
        throw new UnsupportedOperationException();
    }

    public boolean removeRole(String name) {
        return false;
    }

    public org.eclipse.orion.server.useradmin.Role getRole(String name) {
        return this.roles.get(name);
    }

    public org.eclipse.orion.server.useradmin.Role[] getRoles(String filter) throws InvalidSyntaxException {
        return (org.eclipse.orion.server.useradmin.Role[])this.roles.values().toArray();
    }

    public Collection<User> getUsers() {
        if (!this.storage.nodeExists(USERS)) {
            return null;
        }
        ISecurePreferences usersPrefs = this.storage.node(USERS);
        ArrayList<User> users = null;
        String[] stringArray = usersPrefs.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childName = stringArray[n2];
            if (users == null) {
                users = new ArrayList<User>();
            }
            ISecurePreferences userPrefs = usersPrefs.node(childName);
            try {
                User user = new User(childName, userPrefs.get("name", ""), "");
                String[] stringArray2 = userPrefs.node(USER_ROLES).childrenNames();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String roleName = stringArray2[n4];
                    user.addRole((Role)this.getRole(roleName));
                    ++n4;
                }
                users.add(user);
            }
            catch (StorageException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Error loading user: " + childName, (Throwable)e));
            }
            ++n2;
        }
        return users;
    }

    public User getUser(String key, String value) {
        if (key.equals(USER_LOGIN)) {
            ISecurePreferences node = this.findNodeIgnoreCase(this.storage, value);
            if (node == null) {
                return null;
            }
            try {
                User user = new User(node.name(), node.get("name", ""), node.get(USER_PASSWORD, ""));
                String[] stringArray = node.node(USER_ROLES).childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String roleName = stringArray[n2];
                    user.addRole((Role)this.getRole(roleName));
                    ++n2;
                }
                return user;
            }
            catch (StorageException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Can not get user: " + value, (Throwable)e));
            }
        }
        return null;
    }

    public User createUser(User user) {
        ISecurePreferences node = this.findNodeIgnoreCase(this.storage, user.getLogin());
        if (node != null) {
            return null;
        }
        try {
            this.internalCreateOrUpdateUser(this.storage.node("users/" + user.getLogin().toLowerCase()), user);
            return user;
        }
        catch (Exception e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Can not create user: " + user.getLogin(), (Throwable)e));
            return null;
        }
    }

    private ISecurePreferences findNodeIgnoreCase(ISecurePreferences storage, String login) {
        if (login == null) {
            return null;
        }
        ISecurePreferences usersPref = storage.node(USERS);
        String[] childrenNames = usersPref.childrenNames();
        int i = 0;
        while (i < childrenNames.length) {
            if (login.equalsIgnoreCase(usersPref.node(childrenNames[i]).name())) {
                return usersPref.node(childrenNames[i]);
            }
            ++i;
        }
        return null;
    }

    public boolean updateUser(String oldLogin, User user) {
        ISecurePreferences node = this.findNodeIgnoreCase(this.storage, user.getLogin());
        if (node == null) {
            return false;
        }
        try {
            this.internalCreateOrUpdateUser(node, user);
            return true;
        }
        catch (Exception e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Can not update user: " + user.getLogin(), (Throwable)e));
            return false;
        }
    }

    private User internalCreateOrUpdateUser(ISecurePreferences userPrefs, User user) throws StorageException, IOException {
        userPrefs.put("name", user.getName(), false);
        userPrefs.put(USER_PASSWORD, user.getPassword(), true);
        ISecurePreferences rolesPrefs = userPrefs.node(USER_ROLES);
        String[] stringArray = rolesPrefs.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String roleName = stringArray[n2];
            rolesPrefs.node(roleName).removeNode();
            ++n2;
        }
        for (Role role : user.getRoles()) {
            rolesPrefs.node(((org.eclipse.orion.server.useradmin.Role)role).getName());
        }
        userPrefs.flush();
        return user;
    }

    public boolean deleteUser(User user) {
        ISecurePreferences node = this.findNodeIgnoreCase(this.storage, user.getLogin());
        if (node == null) {
            return false;
        }
        node.removeNode();
        try {
            node.flush();
            return true;
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", 4, "Cannot delete user: " + user.getLogin(), (Throwable)e));
            return false;
        }
    }

    public Authorization getAuthorization(org.osgi.service.useradmin.User user) {
        if (user instanceof User) {
            return new WebIdeAuthorization((User)user);
        }
        return new EmptyAuthorization();
    }

    public boolean canCreateUsers() {
        return true;
    }

    public String getStoreName() {
        return "Orion";
    }
}

