/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.io.IOException;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.BinaryResponseWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.servlet.SolrRequestParsers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedSolrServer
extends SolrServer {
    protected final CoreContainer coreContainer;
    protected final String coreName;
    private final SolrRequestParsers _parser;

    @Deprecated
    public EmbeddedSolrServer(SolrCore core) {
        if (core == null) {
            throw new NullPointerException("SolrCore instance required");
        }
        CoreDescriptor dcore = core.getCoreDescriptor();
        if (dcore == null) {
            throw new NullPointerException("CoreDescriptor required");
        }
        CoreContainer cores = dcore.getCoreContainer();
        if (cores == null) {
            throw new NullPointerException("CoreContainer required");
        }
        this.coreName = dcore.getName();
        this.coreContainer = cores;
        this._parser = new SolrRequestParsers(null);
    }

    public EmbeddedSolrServer(CoreContainer coreContainer, String coreName) {
        if (coreContainer == null) {
            throw new NullPointerException("CoreContainer instance required");
        }
        this.coreContainer = coreContainer;
        this.coreName = coreName == null ? "" : coreName;
        this._parser = new SolrRequestParsers(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        NamedList<Object> namedList;
        SolrRequestHandler handler;
        SolrCore core;
        String path = request.getPath();
        if (path == null || !path.startsWith("/")) {
            path = "/select";
        }
        if ((core = this.coreContainer.getCore(this.coreName)) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such core: " + this.coreName);
        }
        SolrParams params = request.getParams();
        if (params == null) {
            params = new ModifiableSolrParams();
        }
        if ((handler = core.getRequestHandler(path)) == null) {
            String qt;
            if (("/select".equals(path) || "/select/".equalsIgnoreCase(path)) && (handler = core.getRequestHandler(qt = params.get("qt"))) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
            }
            if (handler == null && this.coreContainer != null && path.equals(this.coreContainer.getAdminPath())) {
                handler = this.coreContainer.getMultiCoreHandler();
            }
        }
        if (handler == null) {
            core.close();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + path);
        }
        try {
            try {
                SolrQueryRequest req = this._parser.buildRequestFrom(core, params, request.getContentStreams());
                req.getContext().put("path", path);
                SolrQueryResponse rsp = new SolrQueryResponse();
                core.execute(handler, req, rsp);
                if (rsp.getException() != null) {
                    throw new SolrServerException((Throwable)rsp.getException());
                }
                NamedList<Object> normalized = this.getParsedResponse(req, rsp);
                req.close();
                namedList = normalized;
                Object var11_12 = null;
            }
            catch (IOException iox) {
                throw iox;
            }
            catch (Exception ex) {
                throw new SolrServerException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            core.close();
            throw throwable;
        }
        core.close();
        return namedList;
    }

    public NamedList<Object> getParsedResponse(SolrQueryRequest req, SolrQueryResponse rsp) {
        return BinaryResponseWriter.getParsedResponse((SolrQueryRequest)req, (SolrQueryResponse)rsp);
    }
}

