/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressDistributor
implements IProgressMonitor {
    private int totalWork = -1;
    private double worked = 0.0;
    private boolean done = false;
    String taskName;
    String subTaskName;
    private Collection monitors = new ArrayList();

    public synchronized void beginTask(String name, int totalWork) {
        this.totalWork = totalWork;
        this.worked = 0.0;
        this.done = false;
        Iterator it = this.monitors.iterator();
        while (it.hasNext()) {
            IProgressMonitor m = (IProgressMonitor)it.next();
            m.beginTask(name, totalWork);
        }
    }

    public synchronized void done() {
        this.done = true;
        Iterator it = this.monitors.iterator();
        while (it.hasNext()) {
            IProgressMonitor m = (IProgressMonitor)it.next();
            m.done();
        }
    }

    public void internalWorked(double work) {
        this.worked += work;
        Iterator it = this.monitors.iterator();
        while (it.hasNext()) {
            IProgressMonitor m = (IProgressMonitor)it.next();
            m.internalWorked(work);
        }
    }

    public synchronized boolean isCanceled() {
        Iterator it = this.monitors.iterator();
        while (it.hasNext()) {
            IProgressMonitor m = (IProgressMonitor)it.next();
            if (!m.isCanceled()) continue;
            return true;
        }
        return false;
    }

    public void setCanceled(boolean value) {
    }

    public synchronized void setTaskName(String name) {
        this.taskName = name;
        Iterator it = this.monitors.iterator();
        while (it.hasNext()) {
            IProgressMonitor m = (IProgressMonitor)it.next();
            m.setTaskName(name);
        }
    }

    public synchronized void subTask(String name) {
        this.subTaskName = name;
        Iterator it = this.monitors.iterator();
        while (it.hasNext()) {
            IProgressMonitor m = (IProgressMonitor)it.next();
            m.subTask(name);
        }
    }

    public synchronized void worked(int work) {
        this.internalWorked(work);
    }

    public synchronized void addMonitor(IProgressMonitor m) {
        if (this.totalWork > -1) {
            m.beginTask(this.taskName, this.totalWork);
        }
        if (this.subTaskName != null) {
            m.subTask(this.subTaskName);
        }
        if (this.worked > 0.0) {
            m.internalWorked(this.worked);
        }
        if (this.done) {
            m.done();
        }
        this.monitors.add(m);
    }

    public synchronized void removeMonitor(IProgressMonitor m) {
        this.monitors.remove(m);
    }

    public synchronized void operationCanceled() {
        this.totalWork = -1;
        this.worked = 0.0;
        this.done = false;
    }
}

