/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.basic;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class BasicAuthenticationService
implements IAuthenticationService {
    private static Map<String, IOrionCredentialsService> userStores = new HashMap<String, IOrionCredentialsService>();
    private static IOrionCredentialsService defaultUserAdmin;

    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(resp);
        }
        return user;
    }

    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String authHead = req.getHeader("Authorization");
        if (authHead != null && authHead.toUpperCase(Locale.ENGLISH).startsWith(this.getAuthType())) {
            String password;
            String base64 = authHead.substring(6);
            String authString = new String(Base64.decode((byte[])base64.getBytes()));
            if (authString.indexOf(58) < 0) {
                return null;
            }
            String login = authString.substring(0, authString.indexOf(58));
            User user = this.getUserForCredentials(login, password = authString.substring(authString.indexOf(58) + 1));
            if (user != null) {
                defaultUserAdmin.getAuthorization(user);
                return login;
            }
        }
        return null;
    }

    public String getAuthType() {
        return "BASIC";
    }

    private void setNotAuthenticated(HttpServletResponse resp) throws IOException {
        resp.setHeader("WWW-Authenticate", this.getAuthType());
        resp.sendError(401);
    }

    private User getUserForCredentials(String login, String password) {
        IOrionCredentialsService userAdmin = defaultUserAdmin;
        if (userAdmin == null) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.basic", "User admin server is not available"));
            return null;
        }
        User user = userAdmin.getUser("login", login);
        if (user != null && user.hasCredential("password", (Object)password)) {
            return user;
        }
        return null;
    }

    public void configure(Properties properties) {
    }

    public void bindUserAdmin(UserAdmin userAdmin) {
        if (userAdmin instanceof IOrionCredentialsService) {
            IOrionCredentialsService eclipseWebUserAdmin = (IOrionCredentialsService)userAdmin;
            userStores.put(eclipseWebUserAdmin.getStoreName(), eclipseWebUserAdmin);
            if (defaultUserAdmin == null || "Orion".equals(eclipseWebUserAdmin.getStoreName())) {
                defaultUserAdmin = eclipseWebUserAdmin;
            }
        }
    }

    public void unbindUserAdmin(UserAdmin userAdmin) {
        if (userAdmin instanceof IOrionCredentialsService) {
            Iterator<IOrionCredentialsService> iterator;
            IOrionCredentialsService eclipseWebUserAdmin = (IOrionCredentialsService)userAdmin;
            userStores.remove(eclipseWebUserAdmin.getStoreName());
            if (userAdmin.equals(defaultUserAdmin) && (iterator = userStores.values().iterator()).hasNext()) {
                defaultUserAdmin = iterator.next();
            }
        }
    }
}

