/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.util.FS;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.BaseToConfigEntryConverter;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitConfigHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitConfigHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        try {
            switch (GitConfigHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleGet(request, response, path);
                }
                case POST: {
                    return this.handlePost(request, response, path);
                }
                case PUT: {
                    return this.handlePut(request, response, path);
                }
                case DELETE: {
                    return this.handleDelete(request, response, path);
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to process an operation on commits for {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return false;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException, ConfigInvalidException {
        Path p = new Path(path);
        if (p.segment(0).equals("clone") && p.segment(1).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            FileBasedConfig config = this.getLocalConfig(gitDir);
            URI baseLocation = GitConfigHandlerV1.getURI((HttpServletRequest)request);
            JSONObject result = this.configToJSON((Config)config, baseLocation);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            return true;
        }
        if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            FileRepository db = new FileRepository(gitDir);
            StoredConfig config = db.getConfig();
            URI baseLocation = GitConfigHandlerV1.getURI((HttpServletRequest)request);
            String key = p.segment(0);
            String[] keySegments = this.keyToSegments(key);
            if (keySegments == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry key must be provided in the following form: section[.subsection].name", null));
            }
            if (!this.variableExist((Config)config, keySegments)) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, "There is no config entry with key provided", null));
            }
            JSONObject result = this.configEntryToJSON((Config)config, keySegments, baseLocation);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            return true;
        }
        return false;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, JSONException, ServletException, URISyntaxException, ConfigInvalidException {
        Path p = new Path(path);
        if (p.segment(0).equals("clone") && p.segment(1).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            FileBasedConfig config = this.getLocalConfig(gitDir);
            URI baseLocation = GitConfigHandlerV1.getURI((HttpServletRequest)request);
            JSONObject toPost = OrionServlet.readJSONRequest((HttpServletRequest)request);
            String key = toPost.optString("Key", null);
            if (key == null || key.isEmpty()) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Confign entry key must be provided", null));
            }
            String value = toPost.optString("Value", null);
            if (value == null || value.isEmpty()) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Confign entry value must be provided", null));
            }
            String[] keySegments = this.keyToSegments(key);
            if (keySegments == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry key must be provided in the following form: section[.subsection].name", null));
            }
            boolean present = this.variableExist((Config)config, keySegments);
            config.setString(keySegments[0], keySegments[1], keySegments[2], value);
            config.save();
            JSONObject result = this.configEntryToJSON((Config)config, keySegments, baseLocation);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            response.setHeader("Location", result.getString("Location"));
            if (!present) {
                response.setStatus(201);
            }
            return true;
        }
        return false;
    }

    private boolean handlePut(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, JSONException, ServletException, URISyntaxException, ConfigInvalidException {
        Path p = new Path(path);
        if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            FileBasedConfig config = this.getLocalConfig(gitDir);
            URI baseLocation = GitConfigHandlerV1.getURI((HttpServletRequest)request);
            String key = p.segment(0);
            String[] keySegments = this.keyToSegments(key);
            if (keySegments == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry key must be provided in the following form: section[.subsection].name", null));
            }
            JSONObject toPut = OrionServlet.readJSONRequest((HttpServletRequest)request);
            String value = toPut.optString("Value", null);
            if (value == null || value.isEmpty()) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Confign entry value must be provided", null));
            }
            if (!this.variableExist((Config)config, keySegments)) {
                response.setStatus(404);
                return true;
            }
            config.setString(keySegments[0], keySegments[1], keySegments[2], value);
            config.save();
            JSONObject result = this.configEntryToJSON((Config)config, keySegments, baseLocation);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            response.setHeader("Location", result.getString("Location"));
            return true;
        }
        return false;
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, ServletException, ConfigInvalidException {
        Path p = new Path(path);
        if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            FileBasedConfig config = this.getLocalConfig(gitDir);
            String key = p.segment(0);
            String[] keySegments = this.keyToSegments(key);
            if (keySegments == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry key must be provided in the following form: section[.subsection].name", null));
            }
            if (this.variableExist((Config)config, keySegments)) {
                config.unset(keySegments[0], keySegments[1], keySegments[2]);
                config.save();
                response.setStatus(200);
            } else {
                response.setStatus(404);
            }
            return true;
        }
        return false;
    }

    private FileBasedConfig getLocalConfig(File gitDirectory) throws IOException, ConfigInvalidException {
        FileRepository db = new FileRepository(gitDirectory);
        FileBasedConfig config = new FileBasedConfig(db.getConfig().getFile(), FS.detect());
        config.load();
        return config;
    }

    JSONObject configToJSON(Config config, URI baseLocation) throws JSONException, URISyntaxException {
        JSONObject result = new JSONObject();
        JSONArray children = new JSONArray();
        for (String section : config.getSections()) {
            for (String name : config.getNames(section)) {
                String[] stringArray = new String[3];
                stringArray[0] = section;
                stringArray[2] = name;
                children.put((Object)this.configEntryToJSON(config, stringArray, baseLocation));
            }
            for (String subsection : config.getSubsections(section)) {
                for (String name : config.getNames(section, subsection)) {
                    children.put((Object)this.configEntryToJSON(config, new String[]{section, subsection, name}, baseLocation));
                }
            }
        }
        result.put("Children", (Object)children);
        return result;
    }

    JSONObject configEntryToJSON(Config config, String[] keySegments, URI baseLocation) throws JSONException, URISyntaxException {
        String value = config.getString(keySegments[0], keySegments[1], keySegments[2]);
        if (value == null) {
            value = "";
        }
        String key = this.segmentsToKey(keySegments);
        JSONObject result = new JSONObject();
        result.put("Key", (Object)key);
        result.put("Value", (Object)value);
        result.put("Location", (Object)BaseToConfigEntryConverter.REMOVE_FIRST_2.baseToConfigEntryLocation(baseLocation, key));
        return result;
    }

    boolean variableExist(Config config, String[] keySegments) {
        if (keySegments[1] != null && !config.getNames(keySegments[0], keySegments[1]).contains(keySegments[2])) {
            return false;
        }
        return keySegments[1] != null || config.getNames(keySegments[0]).contains(keySegments[2]);
    }

    private String segmentsToKey(String[] segments) {
        if (segments.length == 3) {
            return segments[1] == null ? String.format("%s.%s", segments[0], segments[2]) : String.format("%s.%s.%s", segments[0], segments[1], segments[2]);
        }
        return null;
    }

    private String[] keyToSegments(String key) {
        int firstDot = key.indexOf(46);
        int lastDot = key.lastIndexOf(46);
        if (firstDot == -1 || lastDot == -1) {
            return null;
        }
        String section = key.substring(0, firstDot);
        String subsection = null;
        if (firstDot != lastDot) {
            subsection = key.substring(firstDot + 1, lastDot);
        }
        String name = key.substring(lastDot + 1);
        return new String[]{section, subsection, name};
    }
}

