/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitTagHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitTagHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        try {
            switch (GitTagHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleGet(request, response, path);
                }
                case POST: {
                    return this.handlePost(request, response, path);
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to handle 'tag' request for {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return false;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException {
        Path p = new Path(path);
        File gitDir = GitUtils.getGitDir((IPath)p);
        FileRepository db = new FileRepository(gitDir);
        JSONObject result = new JSONObject();
        JSONArray children = new JSONArray();
        for (Map.Entry revTag : db.getTags().entrySet()) {
            JSONObject tag = new JSONObject();
            tag.put("Name", revTag.getKey());
            tag.put("FullName", (Object)((Ref)revTag.getValue()).getName());
            children.put((Object)tag);
        }
        result.put("Children", (Object)children);
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
        return true;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, CoreException, JGitInternalException, GitAPIException {
        Path p = new Path(path);
        File gitDir = GitUtils.getGitDir((IPath)p);
        FileRepository db = new FileRepository(gitDir);
        Git git = new Git((Repository)db);
        JSONObject toPut = OrionServlet.readJSONRequest((HttpServletRequest)request);
        String tagName = toPut.getString("Name");
        String commitId = toPut.getString("Commit");
        ObjectId objectId = db.resolve(commitId);
        RevWalk walk = new RevWalk((Repository)db);
        RevCommit revCommit = walk.lookupCommit((AnyObjectId)objectId);
        RevTag revTag = GitTagHandlerV1.tag(git, revCommit, tagName);
        JSONObject result = new JSONObject();
        result.put("Name", (Object)revTag.getTagName());
        result.put("ContentLocation", (Object)OrionServlet.getURI((HttpServletRequest)request));
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
        walk.dispose();
        return true;
    }

    static RevTag tag(Git git, RevCommit revCommit, String tagName) throws JGitInternalException, GitAPIException {
        return git.tag().setObjectId((RevObject)revCommit).setName(tagName).call();
    }
}

