/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.form.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.UnsupportedUserStoreException;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormAuthHelper {
    private static Map<String, IOrionCredentialsService> userStores = new HashMap<String, IOrionCredentialsService>();
    private static IOrionCredentialsService defaultUserAdmin;
    private static IOrionUserProfileService userProfileService;
    private static boolean allowAnonymousAccountCreation;

    static {
        allowAnonymousAccountCreation = PreferenceHelper.getString((String)"orion.auth.user.creation", null) == null;
    }

    public static String getAuthenticatedUser(HttpServletRequest req) {
        HttpSession s = req.getSession(true);
        if (s.getAttribute("user") != null) {
            return (String)s.getAttribute("user");
        }
        return null;
    }

    public static void writeLoginResponse(String user, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        try {
            JSONObject array = new JSONObject();
            array.put("login", (Object)user);
            try {
                IOrionUserProfileNode generalUserProfile = FormAuthHelper.getUserProfileService().getUserProfileNode(user, "general");
                Long lastLogin = Long.parseLong(generalUserProfile.get("lastlogintimestamp", ""));
                array.put("lastlogintimestamp", (Object)lastLogin);
            }
            catch (IllegalArgumentException e) {
                LogHelper.log((Throwable)e);
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            resp.getWriter().print(array.toString());
        }
        catch (JSONException jSONException) {}
    }

    public static boolean performAuthentication(HttpServletRequest req, HttpServletResponse resp) throws IOException, UnsupportedUserStoreException {
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.login");
        String login = req.getParameter("login");
        User user = FormAuthHelper.getUserForCredentials(login, req.getParameter("password"), req.getParameter("store"));
        if (user != null) {
            String actualLogin = (String)user.getCredentials().get("login");
            if (logger.isInfoEnabled()) {
                logger.info("Login success: " + actualLogin);
            }
            req.getSession().setAttribute("user", (Object)actualLogin);
            IOrionUserProfileNode userProfileNode = FormAuthHelper.getUserProfileService().getUserProfileNode(actualLogin, "general");
            try {
                userProfileNode.put("lastlogintimestamp", new Long(System.currentTimeMillis()).toString(), false);
                userProfileNode.flush();
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            return true;
        }
        if (login != null) {
            logger.info("Login failed: " + login);
        }
        return false;
    }

    private static User getUserForCredentials(String login, String password, String userStoreId) throws UnsupportedUserStoreException {
        IOrionCredentialsService userAdmin;
        IOrionCredentialsService iOrionCredentialsService = userAdmin = userStoreId == null ? defaultUserAdmin : userStores.get(userStoreId);
        if (userAdmin == null) {
            throw new UnsupportedUserStoreException(userStoreId);
        }
        User user = userAdmin.getUser("login", login);
        if (user != null && user.hasCredential("password", (Object)password)) {
            return user;
        }
        return null;
    }

    public static void performLogout(HttpServletRequest req) {
        HttpSession s = req.getSession(true);
        if (s.getAttribute("user") != null) {
            s.removeAttribute("user");
        }
    }

    public static boolean isSupportedUserStore(String userStoreId) {
        return FormAuthHelper.getSupportedUserStores().contains(userStoreId);
    }

    public static Collection<String> getSupportedUserStores() {
        ArrayList<String> list = new ArrayList<String>(userStores.keySet());
        list.remove(defaultUserAdmin.getStoreName());
        list.add(0, defaultUserAdmin.getStoreName());
        return list;
    }

    public static boolean canAddUsers() {
        return allowAnonymousAccountCreation ? defaultUserAdmin.canCreateUsers() : false;
    }

    public static IOrionCredentialsService getDefaultUserAdmin() {
        return defaultUserAdmin;
    }

    public void setUserAdmin(UserAdmin userAdmin) {
        if (userAdmin instanceof IOrionCredentialsService) {
            IOrionCredentialsService eclipseWebUserAdmin = (IOrionCredentialsService)userAdmin;
            userStores.put(eclipseWebUserAdmin.getStoreName(), eclipseWebUserAdmin);
            if (defaultUserAdmin == null || "Orion".equals(eclipseWebUserAdmin.getStoreName())) {
                defaultUserAdmin = eclipseWebUserAdmin;
            }
        }
    }

    public void unsetUserAdmin(UserAdmin userAdmin) {
        if (userAdmin instanceof IOrionCredentialsService) {
            Iterator<IOrionCredentialsService> iterator;
            IOrionCredentialsService eclipseWebUserAdmin = (IOrionCredentialsService)userAdmin;
            userStores.remove(eclipseWebUserAdmin.getStoreName());
            if (userAdmin.equals(defaultUserAdmin) && (iterator = userStores.values().iterator()).hasNext()) {
                defaultUserAdmin = iterator.next();
            }
        }
    }

    public static IOrionUserProfileService getUserProfileService() {
        return userProfileService;
    }

    public static void bindUserProfileService(IOrionUserProfileService _userProfileService) {
        userProfileService = _userProfileService;
    }

    public static void unbindUserProfileService(IOrionUserProfileService userProfileService) {
        userProfileService = null;
    }
}

