/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;

public abstract class BaseToCloneConverter {
    public static final BaseToCloneConverter FILE = new BaseToCloneConverter(){

        @Override
        public IPath getFilePath(URI base) throws URISyntaxException {
            return new Path(base.getPath()).makeRelative();
        }
    };
    public static final BaseToCloneConverter STATUS = new BaseToCloneConverter(){

        @Override
        public IPath getFilePath(URI base) throws URISyntaxException {
            return new Path(base.getPath()).removeFirstSegments(2).makeRelative();
        }
    };
    public static final BaseToCloneConverter REMOTE = new BaseToCloneConverter(){

        @Override
        public IPath getFilePath(URI base) throws URISyntaxException {
            return new Path(base.getPath()).removeFirstSegments(3).makeRelative();
        }
    };
    public static final BaseToCloneConverter BRANCH = new BaseToCloneConverter(){

        @Override
        public IPath getFilePath(URI base) throws URISyntaxException {
            return new Path(base.getPath()).removeFirstSegments(3).makeRelative();
        }
    };
    public static final BaseToCloneConverter REMOTE_BRANCH = new BaseToCloneConverter(){

        @Override
        public IPath getFilePath(URI base) throws URISyntaxException {
            return new Path(base.getPath()).removeFirstSegments(4).makeRelative();
        }
    };

    public static URI getCloneLocation(URI base, BaseToCloneConverter converter) throws IOException, URISyntaxException, CoreException {
        IPath filePath = converter.getFilePath(base);
        IPath clonePath = BaseToCloneConverter.findClonePath(filePath);
        if (clonePath == null) {
            return null;
        }
        IPath p = new Path("/gitapi").append("clone").append("file").append(clonePath).addTrailingSeparator();
        return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), p.toString(), base.getQuery(), base.getFragment());
    }

    public abstract IPath getFilePath(URI var1) throws URISyntaxException;

    private static IPath findClonePath(IPath filePath) throws CoreException {
        IPath p = filePath.removeFirstSegments(1);
        while (p.segmentCount() > 0) {
            IFileStore fileStore = NewFileServlet.getFileStore((IPath)p);
            if (fileStore == null) {
                return null;
            }
            File file = fileStore.toLocalFile(0, null);
            if (RepositoryCache.FileKey.isGitRepository((File)new File(file, ".git"), (FS)FS.DETECTED)) {
                return p;
            }
            p = p.removeLastSegments(1);
        }
        return null;
    }
}

