/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import com.jcraft.jsch.JSchException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.jsch.HostFingerprintException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class GitJob
extends Job {
    private static final String KEY_SCHEME = "Scheme";
    private static final String KEY_PORT = "Port";
    private static final String KEY_PASSWORD = "Password";
    public static final String KEY_HUMANISH_NAME = "HumanishName";
    public static final String KEY_URL = "Url";
    public static final String KEY_USER = "User";
    public static final String KEY_HOST = "Host";
    protected GitCredentialsProvider credentials;

    private static JSchException getJSchException(Throwable e) {
        if (e instanceof JSchException) {
            return (JSchException)e;
        }
        if (e.getCause() != null) {
            return GitJob.getJSchException(e.getCause());
        }
        return null;
    }

    public JSONObject addRepositoryInfo(JSONObject object) {
        try {
            if (this.credentials != null) {
                object.put(KEY_URL, (Object)this.credentials.getUri().toString());
                if (this.credentials.getUri().getUser() != null) {
                    object.put(KEY_USER, (Object)this.credentials.getUri().getUser());
                }
                if (this.credentials.getUri().getHost() != null) {
                    object.put(KEY_HOST, (Object)this.credentials.getUri().getHost());
                }
                if (this.credentials.getUri().getHumanishName() != null) {
                    object.put(KEY_HUMANISH_NAME, (Object)this.credentials.getUri().getHumanishName());
                }
                if (this.credentials.getUri().getPass() != null) {
                    object.put(KEY_PASSWORD, (Object)this.credentials.getUri().getPass());
                }
                if (this.credentials.getUri().getPort() > 0) {
                    object.put(KEY_PORT, this.credentials.getUri().getPort());
                }
                if (this.credentials.getUri().getScheme() != null) {
                    object.put(KEY_SCHEME, (Object)this.credentials.getUri().getScheme());
                }
            }
        }
        catch (JSONException jSONException) {}
        return object;
    }

    public IStatus getJGitInternalExceptionStatus(JGitInternalException e, String message) {
        JSchException jschEx = GitJob.getJSchException(e);
        if (jschEx != null && jschEx instanceof HostFingerprintException) {
            HostFingerprintException cause = (HostFingerprintException)jschEx;
            return new ServerStatus(4, 403, cause.getMessage(), this.addRepositoryInfo(cause.formJson()), (Throwable)((Object)cause));
        }
        if (jschEx != null && jschEx.getMessage() != null && jschEx.getMessage().toLowerCase(Locale.ENGLISH).contains("auth fail")) {
            return new ServerStatus(4, 401, jschEx.getMessage(), this.addRepositoryInfo(new JSONObject()), (Throwable)jschEx);
        }
        if (e.getCause() instanceof TransportException) {
            TransportException cause = (TransportException)e.getCause();
            if (GitJob.matchMessage(JGitText.get().serviceNotPermitted, cause.getMessage())) {
                return new ServerStatus(4, 403, cause.getMessage(), this.addRepositoryInfo(new JSONObject()), (Throwable)cause);
            }
            if (GitJob.matchMessage(JGitText.get().notAuthorized, cause.getMessage())) {
                return new ServerStatus(4, 401, cause.getMessage(), this.addRepositoryInfo(new JSONObject()), (Throwable)cause);
            }
            return new ServerStatus(4, 500, cause.getMessage() == null ? message : cause.getMessage(), this.addRepositoryInfo(new JSONObject()), (Throwable)cause);
        }
        return new Status(4, "org.eclipse.orion.server.git", message, e.getCause() == null ? e : e.getCause());
    }

    public GitJob(String name, GitCredentialsProvider credentials) {
        super(name);
        this.credentials = credentials;
    }

    public GitJob(String name) {
        super(name);
    }

    private static boolean matchMessage(String pattern, String message) {
        if (message == null) {
            return false;
        }
        int argsNum = 0;
        int i = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '{') {
                ++argsNum;
            }
            ++i;
        }
        Object[] args = new Object[argsNum];
        int i2 = 0;
        while (i2 < args.length) {
            args[i2] = ".*";
            ++i2;
        }
        return Pattern.matches(".*" + MessageFormat.format(pattern, args) + ".*", message);
    }
}

