/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.git.BaseToBranchConverter;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.BaseToIndexConverter;
import org.eclipse.orion.server.git.BaseToRemoteConverter;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.servlets.FetchJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.git.servlets.PushJob;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitRemoteHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitRemoteHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        try {
            switch (GitRemoteHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleGet(request, response, path);
                }
                case POST: {
                    return this.handlePost(request, response, path);
                }
                case DELETE: {
                    return this.handleDelete(request, response, path);
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to handle /git/remote request for {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return false;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException {
        Path p = new Path(path);
        if (p.segment(0).equals("file")) {
            File gitDir = GitUtils.getGitDir((IPath)p);
            FileRepository db = new FileRepository(gitDir);
            Set configNames = db.getConfig().getSubsections("remote");
            JSONObject result = new JSONObject();
            JSONArray children = new JSONArray();
            URI baseLocation = GitRemoteHandlerV1.getURI((HttpServletRequest)request);
            for (String configName : configNames) {
                JSONObject o = new JSONObject();
                o.put("Name", (Object)configName);
                o.put("Type", (Object)"Remote");
                o.put("Location", (Object)BaseToRemoteConverter.REMOVE_FIRST_2.baseToRemoteLocation(baseLocation, configName, ""));
                children.put((Object)o);
            }
            result.put("Children", (Object)children);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            return true;
        }
        if (p.segment(1).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            FileRepository db = new FileRepository(gitDir);
            Set configNames = db.getConfig().getSubsections("remote");
            JSONObject result = new JSONObject();
            URI baseLocation = GitRemoteHandlerV1.getURI((HttpServletRequest)request);
            for (String configName : configNames) {
                String name;
                if (!configName.equals(p.segment(0))) continue;
                result.put("Name", (Object)configName);
                result.put("Type", (Object)"Remote");
                result.put("Location", (Object)BaseToRemoteConverter.REMOVE_FIRST_3.baseToRemoteLocation(baseLocation, p.segment(0), ""));
                JSONArray children = new JSONArray();
                ArrayList<Ref> refs = new ArrayList<Ref>();
                for (Map.Entry refEntry : db.getRefDatabase().getRefs("refs/remotes/" + p.uptoSegment(1)).entrySet()) {
                    if (((Ref)refEntry.getValue()).isSymbolic()) continue;
                    Ref ref = (Ref)refEntry.getValue();
                    name = ref.getName();
                    name = Repository.shortenRefName((String)name).substring("origin".length() + 1);
                    if (db.getBranch().equals(name)) {
                        refs.add(0, ref);
                        continue;
                    }
                    refs.add(ref);
                }
                for (Ref ref : refs) {
                    JSONObject o = new JSONObject();
                    name = ref.getName();
                    o.put("Name", (Object)name);
                    o.put("Type", (Object)"RemoteTrackingBranch");
                    o.put("Id", (Object)ref.getObjectId().name());
                    o.put("Location", (Object)BaseToRemoteConverter.REMOVE_FIRST_3.baseToRemoteLocation(baseLocation, "", Repository.shortenRefName((String)name)));
                    o.put("CommitLocation", (Object)BaseToCommitConverter.getCommitLocation(baseLocation, ref.getObjectId().name(), BaseToCommitConverter.REMOVE_FIRST_3));
                    o.put("HeadLocation", (Object)BaseToCommitConverter.getCommitLocation(baseLocation, "HEAD", BaseToCommitConverter.REMOVE_FIRST_3));
                    o.put("CloneLocation", (Object)BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.REMOTE));
                    o.put("BranchLocation", (Object)BaseToBranchConverter.getBranchLocation(baseLocation, BaseToBranchConverter.REMOTE));
                    o.put("IndexLocation", (Object)BaseToIndexConverter.getIndexLocation(baseLocation, BaseToIndexConverter.REMOTE));
                    children.put((Object)o);
                }
                result.put("Children", (Object)children);
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                return true;
            }
            String msg = NLS.bind((String)"Couldn't find remote : {0}", (Object)p.segment(0));
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
        }
        if (p.segment(2).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            FileRepository db = new FileRepository(gitDir);
            Set configNames = db.getConfig().getSubsections("remote");
            URI baseLocation = GitRemoteHandlerV1.getURI((HttpServletRequest)request);
            for (String configName : configNames) {
                if (!configName.equals(p.segment(0))) continue;
                for (Map.Entry refEntry : db.getRefDatabase().getRefs("refs/remotes/").entrySet()) {
                    Ref ref = (Ref)refEntry.getValue();
                    String name = ref.getName();
                    if (ref.isSymbolic() || !name.equals("refs/remotes/" + p.uptoSegment(2).removeTrailingSeparator())) continue;
                    JSONObject result = new JSONObject();
                    result.put("Name", (Object)name);
                    result.put("Type", (Object)"RemoteTrackingBranch");
                    result.put("Id", (Object)ref.getObjectId().name());
                    result.put("Location", (Object)BaseToRemoteConverter.REMOVE_FIRST_4.baseToRemoteLocation(baseLocation, "", Repository.shortenRefName((String)name)));
                    result.put("CommitLocation", (Object)BaseToCommitConverter.getCommitLocation(baseLocation, ref.getObjectId().name(), BaseToCommitConverter.REMOVE_FIRST_4));
                    result.put("HeadLocation", (Object)BaseToCommitConverter.getCommitLocation(baseLocation, "HEAD", BaseToCommitConverter.REMOVE_FIRST_4));
                    result.put("CloneLocation", (Object)BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.REMOTE_BRANCH));
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                    return true;
                }
            }
            JSONObject errorData = new JSONObject();
            errorData.put("CloneLocation", (Object)BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.REMOTE_BRANCH));
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus((IStatus)new Status(4, "org.eclipse.orion.server.core", "No remote branch found: " + p.uptoSegment(2).removeTrailingSeparator()), 404, errorData));
        }
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Bad request, \"/git/remote/{remote}/{branch}/file/{path}\" expected", null));
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, URISyntaxException {
        Path p = new Path(path);
        if (p.segment(1).equals("file")) {
            String remoteName = p.segment(0);
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            FileRepository db = new FileRepository(gitDir);
            StoredConfig config = db.getConfig();
            config.unsetSection("remote", remoteName);
            config.save();
            return true;
        }
        return false;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException {
        Path p = new Path(path);
        if (p.segment(0).equals("file")) {
            return this.addRemote(request, response, path);
        }
        JSONObject requestObject = OrionServlet.readJSONRequest((HttpServletRequest)request);
        boolean fetch = Boolean.parseBoolean(requestObject.optString("Fetch", null));
        String srcRef = requestObject.optString("PushSrcRef", null);
        boolean tags = requestObject.optBoolean("PushTags", false);
        String username = requestObject.optString("GitSshUsername", null);
        char[] password = requestObject.optString("GitSshPassword", "").toCharArray();
        String knownHosts = requestObject.optString("GitSshKnownHost", null);
        byte[] privateKey = requestObject.optString("GitSshPrivateKey", "").getBytes();
        byte[] publicKey = requestObject.optString("GitSshPublicKey", "").getBytes();
        byte[] passphrase = requestObject.optString("GitSshPassphrase", "").getBytes();
        GitCredentialsProvider cp = new GitCredentialsProvider(null, username, password, knownHosts);
        cp.setPrivateKey(privateKey);
        cp.setPublicKey(publicKey);
        cp.setPassphrase(passphrase);
        if (fetch) {
            return this.fetch(request, response, cp, path);
        }
        if (srcRef != null) {
            if (srcRef.equals("")) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Pushing with an empty source ref is not allowed. Did you mean DELETE?", null));
            }
            return this.push(request, response, path, cp, srcRef, tags);
        }
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Only Fetch:true is currently supported.", null));
    }

    private boolean addRemote(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, CoreException, URISyntaxException {
        Path p = new Path(path);
        JSONObject toPut = OrionServlet.readJSONRequest((HttpServletRequest)request);
        String remoteName = toPut.optString("Remote", null);
        if (remoteName == null || remoteName.isEmpty()) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Remote name must be provided", null));
        }
        String remoteURI = toPut.optString("RemoteURI", null);
        if (remoteURI == null || remoteURI.isEmpty()) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Remote URI must be provided", null));
        }
        String fetchRefSpec = toPut.optString("FetchRefSpec", null);
        String remotePushURI = toPut.optString("PushURI", null);
        String pushRefSpec = toPut.optString("PushRefSpec", null);
        File gitDir = GitUtils.getGitDir((IPath)p);
        FileRepository db = new FileRepository(gitDir);
        StoredConfig config = db.getConfig();
        RemoteConfig rc = new RemoteConfig((Config)config, remoteName);
        rc.addURI(new URIish(remoteURI));
        if (fetchRefSpec == null || fetchRefSpec.isEmpty()) {
            fetchRefSpec = String.format("+refs/heads/*:refs/remotes/%s/*", remoteName);
        }
        rc.addFetchRefSpec(new RefSpec(fetchRefSpec));
        if (remotePushURI != null && !remotePushURI.isEmpty()) {
            rc.addPushURI(new URIish(remotePushURI));
        }
        if (pushRefSpec != null && !pushRefSpec.isEmpty()) {
            rc.addPushRefSpec(new RefSpec(pushRefSpec));
        }
        rc.update((Config)config);
        config.save();
        URI baseLocation = GitRemoteHandlerV1.getURI((HttpServletRequest)request);
        JSONObject result = this.toJSON(remoteName, baseLocation);
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
        response.setHeader("Location", result.getString("Location"));
        response.setStatus(201);
        return true;
    }

    private boolean fetch(HttpServletRequest request, HttpServletResponse response, GitCredentialsProvider cp, String path) throws URISyntaxException, JSONException, IOException {
        Path p = new Path(path);
        FetchJob job = new FetchJob((CredentialsProvider)cp, p);
        job.schedule();
        TaskInfo task = job.getTask();
        JSONObject result = task.toJSON();
        URI taskLocation = this.createTaskLocation(OrionServlet.getURI((HttpServletRequest)request), task.getTaskId());
        result.put("Location", (Object)taskLocation);
        response.setHeader("Location", taskLocation.toString());
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
        response.setStatus(202);
        return true;
    }

    private boolean push(HttpServletRequest request, HttpServletResponse response, String path, GitCredentialsProvider cp, String srcRef, boolean tags) throws ServletException, CoreException, IOException, JSONException, URISyntaxException {
        Path p = new Path(path);
        if (p.segment(2).equals("file")) {
            PushJob job = new PushJob((CredentialsProvider)cp, p, srcRef, tags);
            job.schedule();
            TaskInfo task = job.getTask();
            JSONObject result = task.toJSON();
            URI taskLocation = this.createTaskLocation(OrionServlet.getURI((HttpServletRequest)request), task.getTaskId());
            result.put("Location", (Object)taskLocation);
            response.setHeader("Location", taskLocation.toString());
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            response.setStatus(202);
            return true;
        }
        return false;
    }

    private URI createTaskLocation(URI baseLocation, String taskId) throws URISyntaxException {
        return new URI(baseLocation.getScheme(), baseLocation.getAuthority(), "/task/id/" + taskId, null, null);
    }

    private JSONObject toJSON(String remoteName, URI baseLocation) throws JSONException, URISyntaxException {
        JSONObject result = new JSONObject();
        result.put("Location", (Object)BaseToRemoteConverter.REMOVE_FIRST_2.baseToRemoteLocation(baseLocation, Repository.shortenRefName((String)remoteName), ""));
        return result;
    }
}

