/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitStatusHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitStatusHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String gitPathInfo) throws ServletException {
        File gitDir;
        Set<Map.Entry<IPath, File>> set;
        Path path;
        block4: {
            try {
                path = new Path(gitPathInfo);
                if (!path.hasTrailingSeparator()) {
                    String msg = NLS.bind((String)"Cannot get status on a file: {0}", (Object)gitPathInfo);
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                }
                set = GitUtils.getGitDirs((IPath)path, GitUtils.Traverse.GO_UP).entrySet();
                gitDir = set.iterator().next().getValue();
                if (gitDir != null) break block4;
                return false;
            }
            catch (Exception e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "Error generating status response", (Throwable)e));
            }
        }
        FileRepository db = new FileRepository(gitDir);
        Git git = new Git((Repository)db);
        Status status = git.status().call();
        URI baseLocation = GitStatusHandlerV1.getURI((HttpServletRequest)request);
        JSONObject result = new JSONObject();
        result.put("CloneLocation", (Object)BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.STATUS));
        String relativePath = GitUtils.getRelativePath((IPath)path, set.iterator().next().getKey());
        Path basePath = new Path(relativePath);
        JSONArray children = this.toJSONArray(status.getAdded(), (IPath)basePath, baseLocation, "Default");
        result.put("Added", (Object)children);
        children = this.toJSONArray(status.getChanged(), (IPath)basePath, baseLocation, "Cached");
        result.put("Changed", (Object)children);
        children = this.toJSONArray(status.getMissing(), (IPath)basePath, baseLocation, "Default");
        result.put("Missing", (Object)children);
        children = this.toJSONArray(status.getModified(), (IPath)basePath, baseLocation, "Default");
        result.put("Modified", (Object)children);
        children = this.toJSONArray(status.getRemoved(), (IPath)basePath, baseLocation, "Cached");
        result.put("Removed", (Object)children);
        children = this.toJSONArray(status.getUntracked(), (IPath)basePath, baseLocation, "Default");
        result.put("Untracked", (Object)children);
        children = this.toJSONArray(status.getConflicting(), (IPath)basePath, baseLocation, "Default");
        result.put("Conflicting", (Object)children);
        result.put("IndexLocation", (Object)this.statusToIndexLocation(baseLocation));
        result.put("CommitLocation", (Object)this.statusToCommitLocation(baseLocation, "HEAD"));
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
        return true;
    }

    private JSONArray toJSONArray(Set<String> set, IPath basePath, URI baseLocation, String diffType) throws JSONException, URISyntaxException {
        JSONArray result = new JSONArray();
        for (String s : set) {
            JSONObject object = new JSONObject();
            object.put("Name", (Object)s);
            IPath relative = new Path(s).makeRelativeTo(basePath);
            object.put("Path", (Object)relative);
            URI fileLocation = this.statusToFileLocation(baseLocation);
            object.put("Location", (Object)URIUtil.append((URI)fileLocation, (String)relative.toString()));
            JSONObject gitSection = new JSONObject();
            URI diffLocation = this.statusToDiffLocation(baseLocation, diffType);
            gitSection.put("DiffLocation", (Object)URIUtil.append((URI)diffLocation, (String)relative.toString()));
            object.put("Git", (Object)gitSection);
            URI commitLocation = this.statusToCommitLocation(baseLocation, "HEAD");
            gitSection.put("CommitLocation", (Object)URIUtil.append((URI)commitLocation, (String)relative.toString()));
            object.put("Git", (Object)gitSection);
            URI indexLocation = this.statusToIndexLocation(baseLocation);
            gitSection.put("IndexLocation", (Object)URIUtil.append((URI)indexLocation, (String)relative.toString()));
            object.put("Git", (Object)gitSection);
            result.put((Object)object);
        }
        return result;
    }

    private URI statusToFileLocation(URI u) throws URISyntaxException {
        String uriPath = u.getPath();
        uriPath = uriPath.substring("/gitapi/status".length());
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }

    private URI statusToDiffLocation(URI u, String diffType) throws URISyntaxException {
        String uriPath = u.getPath();
        uriPath = uriPath.substring("/gitapi/status".length());
        uriPath = "/gitapi/diff/" + diffType + uriPath;
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }

    private URI statusToCommitLocation(URI u, String ref) throws URISyntaxException {
        String uriPath = u.getPath();
        uriPath = uriPath.substring("/gitapi/status".length());
        uriPath = "/gitapi/commit/" + ref + uriPath;
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }

    private URI statusToIndexLocation(URI u) throws URISyntaxException {
        String uriPath = u.getPath();
        uriPath = uriPath.substring("/gitapi/status".length());
        uriPath = "/gitapi/index" + uriPath;
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }
}

