/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.form.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.useradmin.UnsupportedUserStoreException;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block10: {
            if (req.getParameter("login") == null && FormAuthHelper.getAuthenticatedUser((HttpServletRequest)req) != null) {
                FormAuthHelper.writeLoginResponse((String)FormAuthHelper.getAuthenticatedUser((HttpServletRequest)req), (HttpServletResponse)resp);
                return;
            }
            try {
                if (FormAuthHelper.performAuthentication((HttpServletRequest)req, (HttpServletResponse)resp)) {
                    if (req.getParameter("redirect") != null && !req.getParameter("redirect").equals("")) {
                        resp.sendRedirect(req.getParameter("redirect"));
                    } else {
                        resp.flushBuffer();
                    }
                    break block10;
                }
                String versionString = req.getHeader("Orion-Version");
                Version version = versionString == null ? null : new Version(versionString);
                String xRequestedWith = req.getHeader("X-Requested-With");
                String invalidLoginError = "Invalid user or password";
                if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
                    RequestDispatcher rd = req.getRequestDispatcher("/loginform?error=" + new String(Base64.encode((byte[])invalidLoginError.getBytes())));
                    rd.include((ServletRequest)req, (ServletResponse)resp);
                } else {
                    resp.setStatus(401);
                    PrintWriter writer = resp.getWriter();
                    JSONObject jsonError = new JSONObject();
                    try {
                        jsonError.put("error", (Object)invalidLoginError);
                        writer.print(jsonError);
                        resp.setContentType("application/json");
                    }
                    catch (JSONException jSONException) {}
                }
                resp.flushBuffer();
            }
            catch (UnsupportedUserStoreException e) {
                LogHelper.log((Throwable)e);
                resp.sendError(401, e.getMessage());
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestDispatcher rd = req.getRequestDispatcher("/loginform/login");
        rd.forward((ServletRequest)req, (ServletResponse)resp);
    }
}

