/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.site;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.hosting.IHostedSite;
import org.eclipse.orion.internal.server.servlets.hosting.ISiteHostingService;
import org.eclipse.orion.internal.server.servlets.hosting.NoMoreHostsException;
import org.eclipse.orion.internal.server.servlets.site.SiteConfiguration;
import org.eclipse.orion.internal.server.servlets.workspace.WebElementResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteConfigurationResourceHandler
extends WebElementResourceHandler<SiteConfiguration> {
    private final ServletResourceHandler<IStatus> statusHandler;

    public SiteConfigurationResourceHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public static SiteConfiguration createFromJSON(WebUser user, String name, String workspace, JSONObject object) throws CoreException {
        if (name == null || name.length() == 0) {
            throw new CoreException((IStatus)new ServerStatus(4, 400, "Name is missing", null));
        }
        if (workspace == null || name.length() == 0) {
            throw new CoreException((IStatus)new ServerStatus(4, 400, "Workspace is missing", null));
        }
        SiteConfiguration site = user.createSiteConfiguration(name, workspace);
        SiteConfigurationResourceHandler.copyProperties(object, site, false);
        site.save();
        return site;
    }

    private static void copyProperties(JSONObject source, SiteConfiguration target, boolean copyName) throws CoreException {
        JSONArray mappings;
        String workspace;
        String hostHint;
        String name;
        if (copyName && (name = source.optString("Name", null)) != null) {
            target.setName(name);
        }
        if ((hostHint = source.optString("HostHint", null)) != null) {
            target.setHostHint(hostHint);
        }
        if ((workspace = source.optString("Workspace", null)) != null) {
            target.setWorkspace(workspace);
        }
        if ((mappings = source.optJSONArray("Mappings")) != null) {
            target.setMappings(mappings);
        }
        if (target.getName() == null || target.getName().length() == 0) {
            throw new CoreException((IStatus)new ServerStatus(4, 400, "Name was not specified", null));
        }
        if (target.getWorkspace() == null || target.getWorkspace().length() == 0) {
            throw new CoreException((IStatus)new ServerStatus(4, 400, "Workspace was not specified", null));
        }
    }

    public static JSONObject toJSON(SiteConfiguration site, URI baseLocation) {
        JSONObject result = WebElementResourceHandler.toJSON(site);
        try {
            result.put("Location", (Object)URIUtil.append((URI)baseLocation, (String)site.getId()));
            result.putOpt("HostHint", (Object)site.getHostHint());
            result.putOpt("Workspace", (Object)site.getWorkspace());
            result.put("Mappings", (Object)site.getMappingsJSON());
        }
        catch (JSONException jSONException) {}
        return result;
    }

    private boolean handleGet(HttpServletRequest req, HttpServletResponse resp, SiteConfiguration site) throws IOException {
        URI location = SiteConfigurationResourceHandler.getURI(req);
        URI baseLocation = location.resolve("");
        JSONObject result = SiteConfigurationResourceHandler.toJSON(site, baseLocation);
        OrionServlet.writeJSONResponse(req, resp, result);
        return true;
    }

    private boolean handlePost(HttpServletRequest req, HttpServletResponse resp, SiteConfiguration site) throws CoreException, IOException, JSONException {
        if (site != null) {
            throw new IllegalArgumentException("Can't POST to an existing site");
        }
        String pathInfo = req.getPathInfo();
        new Path(pathInfo == null ? "" : pathInfo);
        JSONObject requestJson = SiteConfigurationResourceHandler.getRequestJson(req);
        try {
            site = this.doCreateSiteConfiguration(req, requestJson);
            this.changeHostingStatus(req, resp, requestJson, site);
        }
        catch (CoreException e) {
            if (site != null) {
                WebUser user = WebUser.fromUserName(SiteConfigurationResourceHandler.getUserName(req));
                user.removeSiteConfiguration(site);
                try {
                    site.delete();
                }
                catch (CoreException coreException) {}
            }
            throw e;
        }
        URI baseLocation = SiteConfigurationResourceHandler.getURI(req);
        JSONObject result = SiteConfigurationResourceHandler.toJSON(site, baseLocation);
        OrionServlet.writeJSONResponse(req, resp, result);
        resp.setStatus(201);
        resp.addHeader("Location", result.getString("Location"));
        return true;
    }

    private boolean handlePut(HttpServletRequest req, HttpServletResponse resp, SiteConfiguration site) throws IOException, CoreException, JSONException {
        JSONObject requestJson = OrionServlet.readJSONRequest(req);
        SiteConfigurationResourceHandler.copyProperties(requestJson, site, true);
        this.changeHostingStatus(req, resp, requestJson, site);
        site.save();
        URI location = SiteConfigurationResourceHandler.getURI(req);
        URI baseLocation = location.resolve("");
        JSONObject result = SiteConfigurationResourceHandler.toJSON(site, baseLocation);
        OrionServlet.writeJSONResponse(req, resp, result);
        return true;
    }

    private boolean handleDelete(HttpServletRequest req, HttpServletResponse resp, SiteConfiguration site) throws CoreException {
        WebUser user = WebUser.fromUserName(req.getRemoteUser());
        ISiteHostingService hostingService = Activator.getDefault().getSiteHostingService();
        IHostedSite runningSite = hostingService.get(site, user);
        if (runningSite != null) {
            String msg = NLS.bind((String)"Site configuration is running at {0}. Must be stopped before it can be deleted", (Object)runningSite.getHost());
            throw new CoreException((IStatus)new ServerStatus(4, 409, msg, null));
        }
        user.removeSiteConfiguration(site);
        return true;
    }

    @Override
    public boolean handleRequest(HttpServletRequest req, HttpServletResponse resp, SiteConfiguration site) throws ServletException {
        if (site == null && SiteConfigurationResourceHandler.getMethod(req) != ServletResourceHandler.Method.POST) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 404, "Site configuration not found", null));
        }
        try {
            switch (SiteConfigurationResourceHandler.getMethod(req)) {
                case GET: {
                    return this.handleGet(req, resp, site);
                }
                case PUT: {
                    return this.handlePut(req, resp, site);
                }
                case POST: {
                    return this.handlePost(req, resp, site);
                }
                case DELETE: {
                    return this.handleDelete(req, resp, site);
                }
            }
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
        }
        catch (CoreException e) {
            return this.statusHandler.handleRequest(req, resp, e.getStatus());
        }
        return false;
    }

    private static JSONObject getRequestJson(HttpServletRequest req) throws IOException, JSONException {
        WebUser.fromUserName(SiteConfigurationResourceHandler.getUserName(req));
        return OrionServlet.readJSONRequest(req);
    }

    private SiteConfiguration doCreateSiteConfiguration(HttpServletRequest req, JSONObject requestJson) throws CoreException {
        WebUser user = WebUser.fromUserName(SiteConfigurationResourceHandler.getUserName(req));
        String name = SiteConfigurationResourceHandler.computeName(req, requestJson);
        String workspace = requestJson.optString("Workspace", null);
        SiteConfiguration site = SiteConfigurationResourceHandler.createFromJSON(user, name, workspace, requestJson);
        return site;
    }

    private void changeHostingStatus(HttpServletRequest req, HttpServletResponse resp, JSONObject requestJson, SiteConfiguration site) throws CoreException {
        WebUser user = WebUser.fromUserName(SiteConfigurationResourceHandler.getUserName(req));
        JSONObject hostingStatus = requestJson.optJSONObject("HostingStatus");
        if (hostingStatus == null) {
            return;
        }
        String status = hostingStatus.optString("Status");
        try {
            if ("started".equalsIgnoreCase(status)) {
                ISiteHostingService service = SiteConfigurationResourceHandler.getHostingService();
                String editServer = "http://" + req.getHeader("Host");
                service.start(site, user, editServer);
            } else if ("stopped".equalsIgnoreCase(status)) {
                ISiteHostingService service = SiteConfigurationResourceHandler.getHostingService();
                service.stop(site, user);
            } else if (status != null) {
                throw new CoreException((IStatus)new ServerStatus(4, 400, NLS.bind((String)"Status not understood: {0}", (Object)status), null));
            }
        }
        catch (NoMoreHostsException e) {
            throw new CoreException((IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
    }

    private static ISiteHostingService getHostingService() throws CoreException {
        ISiteHostingService service = Activator.getDefault().getSiteHostingService();
        if (service == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Site hosting service unavailable"));
        }
        return service;
    }

    private static String computeName(HttpServletRequest req, JSONObject requestBody) {
        String name = req.getHeader("Slug");
        if (name == null || name.length() == 0) {
            name = requestBody.optString("Name");
        }
        return name;
    }

    private static String getUserName(HttpServletRequest req) {
        return req.getRemoteUser();
    }
}

