/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.workspace.WebElement;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.server.core.resources.Base64Counter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebWorkspace
extends WebElement {
    private static final String WORKSPACE_NODE_NAME = "Workspaces";
    private static final Base64Counter workspaceCounter = new Base64Counter();

    public static WebWorkspace fromId(String id) {
        WebWorkspace result = new WebWorkspace((IEclipsePreferences)scope.getNode(WORKSPACE_NODE_NAME).node(id));
        result.setId(id);
        return result;
    }

    public WebWorkspace(IEclipsePreferences store) {
        super(store);
    }

    public void addProject(WebProject project) {
        JSONArray allProjects;
        String existingProjects = this.store.get("Projects", "[]");
        try {
            allProjects = new JSONArray(existingProjects);
        }
        catch (JSONException jSONException) {
            allProjects = new JSONArray();
        }
        String newProjectId = project.getId();
        int i = 0;
        while (i < allProjects.length()) {
            try {
                if (newProjectId.equals(allProjects.get(i))) {
                    return;
                }
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        JSONObject storedProject = new JSONObject();
        try {
            storedProject.put("Id", (Object)newProjectId);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        allProjects.put((Object)storedProject);
        this.store.put("Projects", allProjects.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String nextWorkspaceId() {
        Base64Counter base64Counter = workspaceCounter;
        synchronized (base64Counter) {
            String candidate;
            do {
                candidate = workspaceCounter.toString();
                workspaceCounter.increment();
            } while (WebWorkspace.exists(candidate));
            return candidate;
        }
    }

    public static boolean exists(String id) {
        try {
            return scope.getNode(WORKSPACE_NODE_NAME).nodeExists(id);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void removeProject(WebProject project) {
        JSONArray allProjects;
        String existingProjects = this.store.get("Projects", "[]");
        try {
            allProjects = new JSONArray(existingProjects);
        }
        catch (JSONException jSONException) {
            allProjects = new JSONArray();
        }
        String newProjectId = project.getId();
        int index = -1;
        int i = 0;
        while (i < allProjects.length()) {
            try {
                if (newProjectId.equals(((JSONObject)allProjects.get(i)).get("Id"))) {
                    index = i;
                    break;
                }
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        if (index == -1) {
            return;
        }
        allProjects.remove(index);
        this.store.put("Projects", allProjects.toString());
    }

    public JSONArray getProjectsJSON() {
        try {
            String projects = this.store.get("Projects", null);
            if (projects != null) {
                return new JSONArray(projects);
            }
        }
        catch (JSONException jSONException) {}
        JSONArray result = new JSONArray();
        return result;
    }
}

