/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.openid.servlet;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.orion.server.openid.core.OpenIdHelper;

public class AuthInitServlet
extends HttpServlet {
    private static final long serialVersionUID = -5422484691883627624L;
    public static final String CSS_LINK_PROPERTY = "STYLES";
    private Properties properties;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendAuthInit(req, resp, this.properties);
    }

    public AuthInitServlet(Properties properties) {
        this.properties = properties;
    }

    private void sendAuthInit(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        if (properties == null) {
            properties = new Properties();
        }
        resp.setHeader("WWW-Authenticate", OpenIdHelper.getAuthType());
        resp.setStatus(200);
        String putStyle = properties.getProperty(CSS_LINK_PROPERTY) == null ? "" : "&styles=" + properties.getProperty(CSS_LINK_PROPERTY);
        RequestDispatcher rd = req.getRequestDispatcher("/openidform/checkuser?redirect=" + req.getRequestURI() + putStyle);
        try {
            try {
                rd.forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (ServletException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            resp.flushBuffer();
        }
    }
}

