/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.help.internal.webapp.parser.ParseElement;
import org.eclipse.help.internal.webapp.utils.JSonHelper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResultParser
extends DefaultHandler {
    private String label = "";
    protected ArrayList items = new ArrayList();

    public ResultParser(String label) {
        this.label = label;
    }

    public void parse(URL tocURL) throws ParserConfigurationException, SAXException, IOException {
        this.parse(tocURL.openStream());
    }

    public void parse(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(in, (DefaultHandler)this);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ArrayList getItems() {
        return this.items;
    }

    public String toString() {
        return this.items.toString();
    }

    public String toJSON() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append("\n   ");
        buf.append("identifier");
        buf.append(":");
        buf.append(JSonHelper.getQuotes("id"));
        buf.append(",");
        buf.append("\n   ");
        buf.append("label");
        buf.append(":");
        buf.append(JSonHelper.getQuotes(this.label));
        buf.append(",");
        buf.append("\n   ");
        buf.append("items");
        buf.append(":");
        buf.append("[");
        int i = 0;
        while (i < this.items.size()) {
            if (i > 0) {
                buf.append(",");
            }
            ParseElement element = (ParseElement)this.items.get(i);
            buf.append(element.toJSON(1));
            ++i;
        }
        if (this.items.size() > 0) {
            buf.append("\n   ");
        }
        buf.append("]");
        buf.append("\n");
        buf.append("}");
        return buf.toString();
    }
}

