/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.authentication.formopenid.Activator;
import org.eclipse.orion.server.authentication.formopenid.httpcontext.BundleEntryHttpContext;
import org.eclipse.orion.server.authentication.formopenid.servlets.AuthInitServlet;
import org.eclipse.orion.server.authentication.formopenid.servlets.FormOpenIdLoginServlet;
import org.eclipse.orion.server.authentication.formopenid.servlets.FormOpenIdLogoutServlet;
import org.eclipse.orion.server.authentication.formopenid.servlets.LoginFormServlet;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.openid.core.OpenIdHelper;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class FormOpenIdAuthenticationService
implements IAuthenticationService {
    private HttpService httpService;
    private Properties defaultAuthenticationProperties;
    public static final String OPENIDS_PROPERTY = "openids";

    public Properties getDefaultAuthenticationProperties() {
        return this.defaultAuthenticationProperties;
    }

    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(req, resp, properties);
        }
        return user;
    }

    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String formUser = FormAuthHelper.getAuthenticatedUser((HttpServletRequest)req);
        if (formUser != null) {
            return formUser;
        }
        return OpenIdHelper.getAuthenticatedUser((HttpServletRequest)req);
    }

    public String getAuthType() {
        return "FORM";
    }

    public void configure(Properties properties) {
        this.defaultAuthenticationProperties = properties;
        try {
            this.httpService.registerServlet("/auth2", (Servlet)new AuthInitServlet(properties), null, (HttpContext)new BundleEntryHttpContext(Activator.getBundleContext().getBundle()));
        }
        catch (Exception exception) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.authentication.formopenid", "Reconfiguring FormOpenIdAuthenticationService"));
            try {
                this.httpService.unregister("/auth2");
                this.httpService.registerServlet("/auth2", (Servlet)new AuthInitServlet(properties), null, (HttpContext)new BundleEntryHttpContext(Activator.getBundleContext().getBundle()));
            }
            catch (ServletException e1) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", 1, "An error occured when registering servlets", (Throwable)e1));
            }
            catch (NamespaceException e1) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", 1, "A namespace error occured when registering servlets", (Throwable)e1));
            }
            catch (IllegalArgumentException e1) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", 1, "FormOpenIdAuthenticationService could not be configured", (Throwable)e1));
            }
        }
    }

    private void setNotAuthenticated(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        resp.setHeader("WWW-Authenticate", "FORM");
        resp.setStatus(401);
        RequestDispatcher rd = req.getRequestDispatcher("/mixlogin/login?redirect=" + req.getRequestURI());
        if (properties != null) {
            req.setAttribute(OPENIDS_PROPERTY, properties.get(OPENIDS_PROPERTY));
        }
        try {
            try {
                rd.forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (ServletException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            resp.flushBuffer();
        }
    }

    public void setHttpService(HttpService hs) {
        this.httpService = hs;
        BundleEntryHttpContext httpContext = new BundleEntryHttpContext(Activator.getBundleContext().getBundle());
        try {
            this.httpService.registerServlet("/mixlogin", (Servlet)new LoginFormServlet(this), null, (HttpContext)httpContext);
            this.httpService.registerResources("/mixloginstatic", "/web", (HttpContext)httpContext);
            this.httpService.registerResources("/openids", "/openids", (HttpContext)httpContext);
            this.httpService.registerServlet("/login", (Servlet)new FormOpenIdLoginServlet(this), null, (HttpContext)httpContext);
            this.httpService.registerServlet("/logout", (Servlet)new FormOpenIdLogoutServlet(), null, (HttpContext)httpContext);
        }
        catch (ServletException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", 1, "An error occured when registering servlets", (Throwable)e));
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.formopenid", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService hs) {
        if (this.httpService != null) {
            this.httpService.unregister("/mixlogin");
            this.httpService.unregister("/mixloginstatic");
            this.httpService.unregister("/login");
            this.httpService.unregister("/logout");
            this.httpService.unregister("/openids");
            this.httpService = null;
        }
    }
}

