/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.BaseToRemoteConverter;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchToJSONConverter {
    public static JSONObject toJSON(Ref ref, Repository db, URI baseLocation, int segmentsToRemove) throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject result = new JSONObject();
        String shortName = Repository.shortenRefName((String)ref.getName());
        result.put("Name", (Object)shortName);
        result.put("Type", (Object)"Branch");
        Path basePath = new Path(baseLocation.getPath());
        IPath newPath = new Path("/gitapi").append("branch").append(shortName).append(basePath.removeFirstSegments(segmentsToRemove));
        URI location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), newPath.toString(), baseLocation.getQuery(), baseLocation.getFragment());
        result.put("Location", (Object)location);
        result.put("CloneLocation", (Object)BaseToCloneConverter.getCloneLocation(location, BaseToCloneConverter.BRANCH));
        result.put("CommitLocation", (Object)BaseToCommitConverter.getCommitLocation(location, shortName, BaseToCommitConverter.REMOVE_FIRST_3));
        result.put("RemoteLocation", (Object)BaseToRemoteConverter.getRemoteBranchLocation(location, shortName, db, BaseToRemoteConverter.REMOVE_FIRST_3));
        result.put("HeadLocation", (Object)BaseToCommitConverter.getCommitLocation(location, "HEAD", BaseToCommitConverter.REMOVE_FIRST_3));
        result.put("Current", shortName.equals(db.getBranch()));
        return result;
    }
}

