/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.git.GitActivator;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.eclipse.orion.server.git.servlets.GitJob;
import org.eclipse.orion.server.git.servlets.WebClone;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CloneJob
extends GitJob {
    private final WebProject project;
    private final WebClone clone;
    private final TaskInfo task;
    private ITaskService taskService;
    private ServiceReference<ITaskService> taskServiceRef;
    private final String user;
    private final String cloneLocation;

    public CloneJob(WebClone clone, CredentialsProvider credentials, String user, String cloneLocation, WebProject project) {
        super("Cloning", (GitCredentialsProvider)credentials);
        this.clone = clone;
        this.user = user;
        this.cloneLocation = cloneLocation;
        this.task = this.createTask();
        this.project = project;
    }

    private TaskInfo createTask() {
        TaskInfo info = this.getTaskService().createTask();
        info.setMessage(NLS.bind((String)"Cloning {0}...", (Object)this.clone.getUrl()));
        this.getTaskService().updateTask(info);
        return info;
    }

    private IStatus doClone() {
        try {
            File cloneFolder = new File(this.clone.getContentLocation().getPath());
            if (!cloneFolder.exists()) {
                cloneFolder.mkdir();
            } else {
                File dotGit = new File(cloneFolder, ".git");
                if (dotGit.exists()) {
                    throw new IOException("Destination folder already exists and contains a repository");
                }
            }
            CloneCommand cc = Git.cloneRepository();
            cc.setBare(false);
            cc.setCredentialsProvider((CredentialsProvider)this.credentials);
            cc.setDirectory(cloneFolder);
            cc.setRemote("origin");
            cc.setURI(this.clone.getUrl());
            Git git = cc.call();
            this.task.setMessage(NLS.bind((String)"Configuring {0}...", (Object)this.clone.getUrl()));
            this.updateTask();
            GitCloneHandlerV1.doConfigureClone(git, this.user);
            git.getRepository().close();
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (JGitInternalException e) {
            return this.getJGitInternalExceptionStatus(e, "An internal git error cloning git remote");
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public TaskInfo getTask() {
        return this.task;
    }

    private ITaskService getTaskService() {
        if (this.taskService == null) {
            BundleContext context = GitActivator.getDefault().getBundleContext();
            if (this.taskServiceRef == null) {
                this.taskServiceRef = context.getServiceReference(ITaskService.class);
                if (this.taskServiceRef == null) {
                    throw new IllegalStateException("Task service not available");
                }
            }
            this.taskService = (ITaskService)context.getService(this.taskServiceRef);
            if (this.taskService == null) {
                throw new IllegalStateException("Task service not available");
            }
        }
        return this.taskService;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        try {
            result = this.doClone();
            if (result.isOK()) {
                this.task.setResultLocation(this.cloneLocation);
                String message = "Clone complete.";
                this.task.setMessage(message);
                result = new Status(0, "org.eclipse.orion.server.git", message);
            } else {
                try {
                    if (this.project != null) {
                        GitCloneHandlerV1.removeProject(this.user, this.project);
                    } else {
                        FileUtils.delete((File)URIUtil.toFile((URI)this.clone.getContentLocation()), (int)1);
                    }
                }
                catch (IOException e) {
                    String msg = "An error occured when cleaning up after a clone failure";
                    result = new ServerStatus(4, 500, msg, (Throwable)e);
                }
            }
            this.task.done(result);
            this.updateTask();
        }
        finally {
            this.cleanUp();
        }
        return result;
    }

    private void cleanUp() {
        this.taskService = null;
        if (this.taskServiceRef != null) {
            GitActivator.getDefault().getBundleContext().ungetService(this.taskServiceRef);
            this.taskServiceRef = null;
        }
    }

    private void updateTask() {
        this.getTaskService().updateTask(this.task);
    }
}

