/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.BaseToRemoteConverter;
import org.eclipse.orion.server.git.BranchToJSONConverter;
import org.eclipse.orion.server.git.servlets.GitTagHandlerV1;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitCommitHandlerV1
extends ServletResourceHandler<String> {
    private static final int PAGE_SIZE = 50;
    private ServletResourceHandler<IStatus> statusHandler;

    GitCommitHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        Repository db = null;
        try {
            Path p = new Path(path);
            switch (GitCommitHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    boolean bl = this.handleGet(request, response, db, p);
                    return bl;
                }
                case PUT: {
                    boolean bl = this.handlePut(request, response, db, p);
                    return bl;
                }
                case POST: {
                    boolean bl = this.handlePost(request, response, db, p);
                    return bl;
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to process an operation on commits for {0}", (Object)path);
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
            return bl;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    private boolean createCommitLocation(HttpServletRequest request, HttpServletResponse response, Repository db, String newCommitToCreatelocation) throws IOException, JSONException, URISyntaxException {
        URI u = GitCommitHandlerV1.getURI((HttpServletRequest)request);
        Path p = new Path(u.getPath());
        Path np = new Path("/");
        int i = 0;
        while (i < p.segmentCount()) {
            String s = p.segment(i);
            if (i == 2) {
                s = String.valueOf(s) + ".." + newCommitToCreatelocation;
            }
            np = np.append(s);
            ++i;
        }
        if (p.hasTrailingSeparator()) {
            np = np.addTrailingSeparator();
        }
        URI nu = new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), np.toString(), u.getQuery(), u.getFragment());
        response.setHeader("Location", nu.toString());
        response.setStatus(200);
        return true;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, Repository db, Path path) throws CoreException, IOException, ServletException, JSONException, URISyntaxException {
        IPath filePath = path.hasTrailingSeparator() ? path.removeFirstSegments(1) : path.removeFirstSegments(1).removeLastSegments(1);
        Set<Map.Entry<IPath, File>> set = GitUtils.getGitDirs(filePath, GitUtils.Traverse.GO_UP).entrySet();
        File gitDir = set.iterator().next().getValue();
        if (gitDir == null) {
            return false;
        }
        db = new FileRepository(gitDir);
        String parts = request.getParameter("parts");
        String pattern = GitUtils.getRelativePath((IPath)path, set.iterator().next().getKey());
        if (path.segmentCount() > 3 && "body".equals(parts)) {
            return this.handleGetCommitBody(request, response, db, path.segment(0), pattern);
        }
        if (path.segmentCount() > 2 && (parts == null || "log".equals(parts))) {
            return this.handleGetCommitLog(request, response, db, path.segment(0), pattern);
        }
        return false;
    }

    private boolean handleGetCommitBody(HttpServletRequest request, HttpServletResponse response, Repository db, String ref, String pattern) throws AmbiguousObjectException, IOException, ServletException {
        ObjectId refId = db.resolve(ref);
        if (refId == null) {
            String msg = NLS.bind((String)"Failed to generate commit log for ref {0}", (Object)ref);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
        }
        RevWalk walk = new RevWalk(db);
        walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(Collections.singleton(pattern)), (TreeFilter)TreeFilter.ANY_DIFF));
        RevCommit commit = walk.parseCommit((AnyObjectId)refId);
        TreeWalk w = TreeWalk.forPath((Repository)db, (String)pattern, (RevTree)commit.getTree());
        if (w == null) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, null, null));
        }
        ObjectId blobId = w.getObjectId(0);
        ObjectStream stream = db.open((AnyObjectId)blobId, 3).openStream();
        IOUtilities.pipe((InputStream)stream, (OutputStream)response.getOutputStream(), (boolean)true, (boolean)false);
        return true;
    }

    private boolean handleGetCommitLog(HttpServletRequest request, HttpServletResponse response, Repository db, String refIdsRange, String path) throws AmbiguousObjectException, IOException, ServletException, JSONException, URISyntaxException, CoreException {
        int page = request.getParameter("page") != null ? new Integer(request.getParameter("page")) : 0;
        int pageSize = request.getParameter("pageSize") != null ? new Integer(request.getParameter("pageSize")) : 50;
        ObjectId toObjectId = null;
        ObjectId fromObjectId = null;
        Ref toRefId = null;
        Ref fromRefId = null;
        if (refIdsRange.contains("..")) {
            String[] commits = refIdsRange.split("\\.\\.");
            if (commits.length != 2) {
                String msg = NLS.bind((String)"Failed to generate commit log for ref {0}", (Object)refIdsRange);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            fromObjectId = db.resolve(commits[0]);
            fromRefId = db.getRef(commits[0]);
            if (fromObjectId == null) {
                String msg = NLS.bind((String)"Failed to generate commit log for ref {0}", (Object)commits[0]);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            toObjectId = db.resolve(commits[1]);
            toRefId = db.getRef(commits[1]);
            if (toObjectId == null) {
                NLS.bind((String)"Failed to generate commit log for ref {0}", (Object)commits[1]);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, "No ref or commit found: " + commits[1], null));
            }
        } else {
            toObjectId = db.resolve(refIdsRange);
            toRefId = db.getRef(refIdsRange);
            if (toObjectId == null) {
                NLS.bind((String)"Failed to generate commit log for ref {0}", (Object)refIdsRange);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, "No ref or commit found: " + refIdsRange, null));
            }
        }
        Git git = new Git(db);
        LogCommand log = git.log();
        log.add((AnyObjectId)toObjectId);
        if (fromObjectId != null) {
            log.not((AnyObjectId)fromObjectId);
        }
        TreeFilter filter = null;
        boolean isRoot = true;
        if (path != null && !"".equals(path)) {
            filter = AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(Collections.singleton(path)), (TreeFilter)TreeFilter.ANY_DIFF);
            log.addPath(path);
            isRoot = false;
        }
        try {
            String refTargetName;
            Iterable commits = log.call();
            JSONObject result = this.toJSON(db, OrionServlet.getURI((HttpServletRequest)request), commits, page, pageSize, filter, isRoot);
            result.put("RepositoryPath", (Object)(isRoot ? "" : path));
            if (toRefId != null) {
                result.put("RemoteLocation", (Object)BaseToRemoteConverter.getRemoteBranchLocation(GitCommitHandlerV1.getURI((HttpServletRequest)request), Repository.shortenRefName((String)toRefId.getName()), db, BaseToRemoteConverter.REMOVE_FIRST_3));
                refTargetName = toRefId.getTarget().getName();
                if (refTargetName.startsWith("refs/heads/")) {
                    result.put("toRef", (Object)BranchToJSONConverter.toJSON(toRefId.getTarget(), db, GitCommitHandlerV1.getURI((HttpServletRequest)request), 3));
                }
            }
            if (fromRefId != null && (refTargetName = fromRefId.getTarget().getName()).startsWith("refs/heads/")) {
                result.put("fromRef", (Object)BranchToJSONConverter.toJSON(fromRefId.getTarget(), db, GitCommitHandlerV1.getURI((HttpServletRequest)request), 3));
            }
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            return true;
        }
        catch (NoHeadException e) {
            String msg = NLS.bind((String)"No HEAD reference found when generating log for ref {0}", (Object)refIdsRange);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        catch (JGitInternalException e) {
            String msg = NLS.bind((String)"An internal error occured when generating log for ref {0}", (Object)refIdsRange);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
    }

    private JSONObject toJSON(Repository db, URI baseLocation, Iterable<RevCommit> commits, int page, int pageSize, TreeFilter filter, boolean isRoot) throws JSONException, URISyntaxException, MissingObjectException, IOException {
        boolean pageable = page > 0;
        int startIndex = (page - 1) * pageSize;
        int index = 0;
        JSONObject result = new JSONObject();
        JSONArray children = new JSONArray();
        for (RevCommit revCommit : commits) {
            if (pageable && index < startIndex) {
                ++index;
                continue;
            }
            if (pageable && index >= startIndex + pageSize) break;
            ++index;
            children.put((Object)this.toJSON(db, revCommit, baseLocation, filter, isRoot));
        }
        result.put("Children", (Object)children);
        return result;
    }

    private JSONObject toJSON(Repository db, RevCommit revCommit, URI baseLocation, TreeFilter filter, boolean isRoot) throws JSONException, URISyntaxException, IOException {
        JSONObject commit = new JSONObject();
        commit.put("Location", (Object)this.createCommitLocation(baseLocation, revCommit.getName(), null));
        commit.put("ContentLocation", (Object)this.createCommitLocation(baseLocation, revCommit.getName(), "parts=body"));
        commit.put("DiffLocation", (Object)this.createDiffLocation(baseLocation, revCommit.getName(), null, null, isRoot));
        commit.put("Name", (Object)revCommit.getName());
        commit.put("AuthorName", (Object)revCommit.getAuthorIdent().getName());
        commit.put("AuthorEmail", (Object)revCommit.getAuthorIdent().getEmailAddress());
        commit.put("CommitterName", (Object)revCommit.getCommitterIdent().getName());
        commit.put("CommitterEmail", (Object)revCommit.getCommitterIdent().getEmailAddress());
        commit.put("Time", (long)revCommit.getCommitTime() * 1000L);
        commit.put("Message", (Object)revCommit.getFullMessage());
        commit.put("Children", (Object)this.toJSON(GitCommitHandlerV1.getTagsForCommit(db, revCommit)));
        commit.put("Type", (Object)"Commit");
        if (revCommit.getParentCount() > 0) {
            JSONArray diffs = new JSONArray();
            TreeWalk tw = new TreeWalk(db);
            RevWalk rw = new RevWalk(db);
            RevCommit parent = rw.parseCommit((AnyObjectId)revCommit.getParent(0));
            tw.reset(new AnyObjectId[]{parent.getTree(), revCommit.getTree()});
            tw.setRecursive(true);
            if (filter != null) {
                tw.setFilter(filter);
            } else {
                tw.setFilter(TreeFilter.ANY_DIFF);
            }
            List l = DiffEntry.scan((TreeWalk)tw);
            for (DiffEntry entr : l) {
                JSONObject diff = new JSONObject();
                diff.put("Type", (Object)"Diff");
                diff.put("NewPath", (Object)entr.getNewPath());
                diff.put("OldPath", (Object)entr.getOldPath());
                diff.put("ChangeType", (Object)entr.getChangeType().toString());
                String path = entr.getChangeType() != DiffEntry.ChangeType.DELETE ? entr.getNewPath() : entr.getOldPath();
                diff.put("DiffLocation", (Object)this.createDiffLocation(baseLocation, revCommit.getName(), revCommit.getParent(0).getName(), path, isRoot));
                diffs.put((Object)diff);
            }
            tw.release();
            commit.put("Diffs", (Object)diffs);
        }
        return commit;
    }

    private JSONArray toJSON(Map<String, Ref> revTags) throws JSONException {
        JSONArray children = new JSONArray();
        for (Map.Entry<String, Ref> revTag : revTags.entrySet()) {
            JSONObject tag = new JSONObject();
            tag.put("Name", (Object)revTag.getKey());
            tag.put("FullName", (Object)revTag.getValue().getName());
            children.put((Object)tag);
        }
        return children;
    }

    private URI createCommitLocation(URI baseLocation, String commitName, String parameters) throws URISyntaxException {
        return new URI(baseLocation.getScheme(), baseLocation.getAuthority(), "/gitapi/commit/" + commitName + "/" + new Path(baseLocation.getPath()).removeFirstSegments(3), parameters, null);
    }

    private URI createDiffLocation(URI baseLocation, String toRefId, String fromRefId, String path, boolean isRoot) throws URISyntaxException {
        String diffPath = "/gitapi/diff/";
        if (fromRefId != null) {
            diffPath = String.valueOf(diffPath) + fromRefId + "..";
        }
        diffPath = String.valueOf(diffPath) + toRefId + "/";
        if (path == null) {
            diffPath = String.valueOf(diffPath) + new Path(baseLocation.getPath()).removeFirstSegments(3);
        } else if (isRoot) {
            diffPath = String.valueOf(diffPath) + new Path(baseLocation.getPath()).removeFirstSegments(3).append(path);
        } else {
            Path p = new Path(baseLocation.getPath());
            diffPath = String.valueOf(diffPath) + p.removeLastSegments(p.segmentCount() - 5).removeFirstSegments(3).append(path);
        }
        return new URI(baseLocation.getScheme(), baseLocation.getAuthority(), diffPath, null, null);
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, Repository db, Path path) throws ServletException, NoFilepatternException, IOException, JSONException, CoreException, URISyntaxException {
        IPath filePath = path.hasTrailingSeparator() ? path.removeFirstSegments(1) : path.removeFirstSegments(1).removeLastSegments(1);
        Set<Map.Entry<IPath, File>> set = GitUtils.getGitDirs(filePath, GitUtils.Traverse.GO_UP).entrySet();
        File gitDir = set.iterator().next().getValue();
        if (gitDir == null) {
            return false;
        }
        db = new FileRepository(gitDir);
        JSONObject requestObject = OrionServlet.readJSONRequest((HttpServletRequest)request);
        String commitToMerge = requestObject.optString("Merge", null);
        if (commitToMerge != null) {
            return this.merge(request, response, db, commitToMerge);
        }
        String newCommitToCreatelocation = requestObject.optString("New", null);
        if (newCommitToCreatelocation != null) {
            return this.createCommitLocation(request, response, db, newCommitToCreatelocation);
        }
        ObjectId refId = db.resolve(path.segment(0));
        if (refId == null || !"HEAD".equals(path.segment(0))) {
            String msg = NLS.bind((String)"Commit failed. Ref must be HEAD and is {0}", (Object)path.segment(0));
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
        }
        String message = requestObject.optString("Message", null);
        if (message == null || message.isEmpty()) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Missing commit message.", null));
        }
        boolean amend = Boolean.parseBoolean(requestObject.optString("Amend", null));
        Git git = new Git(db);
        CommitCommand commit = git.commit();
        boolean isRoot = true;
        String pattern = GitUtils.getRelativePath(path.removeFirstSegments(1), set.iterator().next().getKey());
        if (!pattern.isEmpty()) {
            commit.setOnly(pattern);
            isRoot = false;
        }
        try {
            RevCommit lastCommit = commit.setAmend(amend).setMessage(message).call();
            JSONObject result = this.toJSON(db, lastCommit, GitCommitHandlerV1.getURI((HttpServletRequest)request), null, isRoot);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            return true;
        }
        catch (GitAPIException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "An error occured when commiting.", (Throwable)e));
        }
        catch (JGitInternalException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An internal error occured when commiting.", (Throwable)e));
        }
    }

    private boolean merge(HttpServletRequest request, HttpServletResponse response, Repository db, String commitToMerge) throws ServletException, JSONException {
        try {
            ObjectId objectId = db.resolve(commitToMerge);
            Git git = new Git(db);
            MergeResult mergeResult = git.merge().include((AnyObjectId)objectId).call();
            JSONObject result = new JSONObject();
            result.put("Result", (Object)mergeResult.getMergeStatus().name());
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            return true;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when merging.", (Throwable)e));
        }
        catch (GitAPIException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when merging.", (Throwable)e));
        }
        catch (JGitInternalException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when merging.", e.getCause()));
        }
    }

    private boolean handlePut(HttpServletRequest request, HttpServletResponse response, Repository db, Path path) throws ServletException, IOException, JSONException, CoreException, URISyntaxException, JGitInternalException, GitAPIException {
        IPath filePath = path.removeFirstSegments(1);
        Set<Map.Entry<IPath, File>> set = GitUtils.getGitDirs(filePath, GitUtils.Traverse.GO_UP).entrySet();
        File gitDir = set.iterator().next().getValue();
        if (gitDir == null) {
            return false;
        }
        db = new FileRepository(gitDir);
        boolean isRoot = "".equals(GitUtils.getRelativePath((IPath)path, set.iterator().next().getKey()));
        JSONObject toPut = OrionServlet.readJSONRequest((HttpServletRequest)request);
        String tagName = toPut.getString("Name");
        if (tagName != null) {
            return this.tag(request, response, db, path.segment(0), tagName, isRoot);
        }
        return false;
    }

    private boolean tag(HttpServletRequest request, HttpServletResponse response, Repository db, String commitId, String tagName, boolean isRoot) throws AmbiguousObjectException, IOException, JGitInternalException, GitAPIException, JSONException, URISyntaxException {
        Git git = new Git(db);
        ObjectId objectId = db.resolve(commitId);
        RevWalk walk = new RevWalk(db);
        RevCommit revCommit = walk.lookupCommit((AnyObjectId)objectId);
        walk.parseBody((RevObject)revCommit);
        GitTagHandlerV1.tag(git, revCommit, tagName);
        JSONObject result = this.toJSON(db, revCommit, OrionServlet.getURI((HttpServletRequest)request), null, isRoot);
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
        walk.dispose();
        return true;
    }

    private static Map<String, Ref> getTagsForCommit(Repository repo, RevCommit commit) throws MissingObjectException, IOException {
        HashMap<String, Ref> revTags = new HashMap<String, Ref>();
        RevWalk walk = new RevWalk(repo);
        walk.reset();
        for (Map.Entry revTag : repo.getTags().entrySet()) {
            RevCommit tagCommit;
            RevObject obj = walk.parseAny((AnyObjectId)((Ref)revTag.getValue()).getObjectId());
            if (obj instanceof RevCommit) {
                tagCommit = (RevCommit)obj;
            } else {
                if (!(obj instanceof RevTag)) continue;
                tagCommit = walk.parseCommit((AnyObjectId)((RevTag)obj).getObject());
            }
            if (!commit.equals((AnyObjectId)tagCommit) && !walk.isMergedInto(commit, tagCommit)) continue;
            revTags.put((String)revTag.getKey(), (Ref)revTag.getValue());
        }
        return revTags;
    }
}

