/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.git.servlets.Diff;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class GitDiffHandlerV1
extends ServletResourceHandler<String> {
    private static final String EOL = "\r\n";
    private ServletResourceHandler<IStatus> statusHandler;

    GitDiffHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String gitPathInfo) throws ServletException {
        FileRepository db = null;
        try {
            Path path = new Path(gitPathInfo);
            Path filePath = path.hasTrailingSeparator() ? path : path.removeLastSegments(1);
            Set<Map.Entry<IPath, File>> set = GitUtils.getGitDirs(filePath.removeFirstSegments(1), GitUtils.Traverse.GO_UP).entrySet();
            File gitDir = set.iterator().next().getValue();
            if (gitDir == null) {
                return false;
            }
            db = new FileRepository(gitDir);
            switch (GitDiffHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    String parts = request.getParameter("parts");
                    String pattern = GitUtils.getRelativePath(path.removeFirstSegments(1), set.iterator().next().getKey());
                    String string = pattern = pattern.isEmpty() ? null : pattern;
                    if (parts == null || "uris,diff".equals(parts) || "diff,uris".equals(parts)) {
                        boolean bl = this.handleMultiPartGet(request, response, (Repository)db, path, pattern);
                        return bl;
                    }
                    if ("uris".equals(parts)) {
                        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)this.jsonForGetUris(request, response, (Repository)db, path));
                        return true;
                    }
                    if ("diff".equals(parts)) {
                        boolean bl = this.handleGetDiff(request, response, (Repository)db, path.segment(0), pattern, (OutputStream)response.getOutputStream());
                        return bl;
                    }
                }
                case POST: {
                    boolean bl = this.handlePost(request, response, (Repository)db, path);
                    return bl;
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to generate diff for {0}", (Object)gitPathInfo);
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
            return bl;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    private boolean handleGetDiff(HttpServletRequest request, HttpServletResponse response, Repository db, String scope, String pattern, OutputStream out) throws Exception {
        Diff diff = new Diff(out);
        diff.setRepository(db);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                String msg = NLS.bind((String)"Failed to generate diff for {0}", (Object)scope);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            diff.setOldTree(this.getTreeIterator(db, commits[0]));
            diff.setNewTree(this.getTreeIterator(db, commits[1]));
        } else if (scope.equals("Cached")) {
            diff.setCached(true);
        } else if (scope.equals("Default")) {
            diff.setCached(false);
        } else {
            diff.setOldTree(this.getTreeIterator(db, scope));
        }
        if (pattern != null) {
            diff.setPathFilter((TreeFilter)PathFilter.create((String)pattern));
        }
        diff.run();
        return true;
    }

    private JSONObject jsonForGetUris(HttpServletRequest request, HttpServletResponse response, Repository db, Path path) throws Exception {
        JSONObject o = new JSONObject();
        JSONObject gitSection = new JSONObject();
        URI link = GitDiffHandlerV1.getURI((HttpServletRequest)request);
        gitSection.put("DiffLocation", (Object)link);
        gitSection.put("Old", (Object)this.getOldLocation(link, path));
        gitSection.put("New", (Object)this.getNewLocation(link, path));
        gitSection.put("Base", (Object)this.getBaseLocation(link, db, path));
        o.put("Git", (Object)gitSection);
        return o;
    }

    private boolean handleMultiPartGet(HttpServletRequest request, HttpServletResponse response, Repository db, Path path, String pattern) throws Exception {
        String boundary = this.createBoundaryString();
        response.setHeader("Content-Type", "multipart/related; boundary=\"" + boundary + '\"');
        ServletOutputStream outputStream = response.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream);
        out.write("--" + boundary + EOL);
        out.write("Content-Type: application/json; charset=UTF-8\r\n\r\n");
        ((Writer)out).flush();
        JSONObject getURIs = this.jsonForGetUris(request, response, db, path);
        out.write(getURIs.toString());
        out.write("\r\n--" + boundary + EOL);
        out.write("Content-Type: plain/text\r\n\r\n");
        ((Writer)out).flush();
        this.handleGetDiff(request, response, db, path.segment(0), pattern, (OutputStream)outputStream);
        out.write(EOL);
        ((Writer)out).flush();
        return true;
    }

    String createBoundaryString() {
        return new UniversalUniqueIdentifier().toBase64String();
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, Repository db, Path path) throws IOException, JSONException, URISyntaxException {
        JSONObject requestObject = OrionServlet.readJSONRequest((HttpServletRequest)request);
        URI u = GitDiffHandlerV1.getURI((HttpServletRequest)request);
        Path p = new Path(u.getPath());
        Path np = new Path("/");
        int i = 0;
        while (i < p.segmentCount()) {
            String s = p.segment(i);
            if (i == 2) {
                s = String.valueOf(s) + ".." + requestObject.getString("New");
            }
            np = np.append(s);
            ++i;
        }
        URI nu = new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), np.toString(), u.getQuery(), u.getFragment());
        response.setHeader("Location", nu.toString());
        response.setStatus(200);
        return true;
    }

    private AbstractTreeIterator getTreeIterator(Repository db, String name) throws IOException {
        ObjectId id = db.resolve(name);
        if (id == null) {
            throw new IllegalArgumentException(name);
        }
        CanonicalTreeParser p = new CanonicalTreeParser();
        ObjectReader or = db.newObjectReader();
        try {
            p.reset(or, (AnyObjectId)new RevWalk(db).parseTree((AnyObjectId)id));
            CanonicalTreeParser canonicalTreeParser = p;
            return canonicalTreeParser;
        }
        finally {
            or.release();
        }
    }

    private URI getOldLocation(URI location, Path path) throws URISyntaxException {
        String scope = path.segment(0);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                throw new IllegalArgumentException();
            }
            IPath p = new Path("/gitapi/commit").append(commits[0]).append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Cached")) {
            IPath p = new Path("/gitapi/commit").append("HEAD").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Default")) {
            IPath p = new Path("/gitapi/index").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), null, null);
        }
        IPath p = new Path("/gitapi/commit").append(scope).append(path.removeFirstSegments(1));
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
    }

    private URI getNewLocation(URI location, Path path) throws URISyntaxException {
        String scope = path.segment(0);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                throw new IllegalArgumentException();
            }
            IPath p = new Path("/gitapi/commit").append(commits[1]).append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Cached")) {
            IPath p = new Path("/gitapi/index").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), null, null);
        }
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), path.removeFirstSegments(1).makeAbsolute().toString(), null, null);
    }

    private URI getBaseLocation(URI location, Repository db, Path path) throws URISyntaxException, IOException {
        String scope = path.segment(0);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                throw new IllegalArgumentException();
            }
            ResolveMerger merger = new ResolveMerger(db){

                protected boolean mergeImpl() throws IOException {
                    return false;
                }
            };
            merger.merge((AnyObjectId[])new ObjectId[]{db.resolve(commits[0]), db.resolve(commits[1])});
            RevCommit baseCommit = merger.getBaseCommit(0, 1);
            IPath p = new Path("/gitapi/commit").append(baseCommit.getId().getName()).append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Cached")) {
            IPath p = new Path("/gitapi/commit").append("HEAD").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        IPath p = new Path("/gitapi/index").append(path.removeFirstSegments(1));
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), null, null);
    }
}

