/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.git.GitActivator;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.servlets.GitJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PushJob
extends GitJob {
    private final TaskInfo task;
    private ITaskService taskService;
    private ServiceReference<ITaskService> taskServiceRef;
    private Path p;
    private String srcRef;
    private boolean tags;

    public PushJob(CredentialsProvider credentials, Path path, String srcRef, boolean tags) {
        super("Pushing", (GitCredentialsProvider)credentials);
        this.p = path;
        this.srcRef = srcRef;
        this.tags = tags;
        this.task = this.createTask();
    }

    private TaskInfo createTask() {
        TaskInfo info = this.getTaskService().createTask();
        info.setMessage(NLS.bind((String)"Pushing {0}...", (Object)this.p.segment(0)));
        this.getTaskService().updateTask(info);
        return info;
    }

    private IStatus doPush() throws IOException, CoreException, JGitInternalException, InvalidRemoteException, URISyntaxException, JSONException {
        File gitDir = GitUtils.getGitDir(this.p.removeFirstSegments(2));
        FileRepository db = new FileRepository(gitDir);
        Git git = new Git((Repository)db);
        PushCommand pushCommand = git.push();
        RemoteConfig remoteConfig = new RemoteConfig((Config)git.getRepository().getConfig(), this.p.segment(0));
        this.credentials.setUri((URIish)remoteConfig.getURIs().get(0));
        pushCommand.setCredentialsProvider((CredentialsProvider)this.credentials);
        RefSpec spec = new RefSpec(String.valueOf(this.srcRef) + ":" + "refs/heads/" + this.p.segment(1));
        pushCommand.setRemote(this.p.segment(0)).setRefSpecs(new RefSpec[]{spec});
        if (this.tags) {
            pushCommand.setPushTags();
        }
        Iterable resultIterable = pushCommand.call();
        PushResult pushResult = (PushResult)resultIterable.iterator().next();
        HashSet<RemoteRefUpdate.Status> statusSet = new HashSet<RemoteRefUpdate.Status>();
        for (RemoteRefUpdate rru : pushResult.getRemoteUpdates()) {
            String rm = rru.getRemoteName();
            if (!this.p.segment(1).equals(Repository.shortenRefName((String)rm)) && !rm.startsWith("refs/tags/")) continue;
            RemoteRefUpdate.Status status = rru.getStatus();
            if (status != RemoteRefUpdate.Status.OK && status != RemoteRefUpdate.Status.UP_TO_DATE) {
                return new Status(2, "org.eclipse.orion.server.git", status.name());
            }
            statusSet.add(status);
        }
        if (statusSet.contains(RemoteRefUpdate.Status.OK)) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.orion.server.git", RemoteRefUpdate.Status.UP_TO_DATE.name());
    }

    public TaskInfo getTask() {
        return this.task;
    }

    private ITaskService getTaskService() {
        BundleContext context = GitActivator.getDefault().getBundleContext();
        this.taskServiceRef = context.getServiceReference(ITaskService.class);
        if (this.taskServiceRef == null) {
            throw new IllegalStateException("Task service not available");
        }
        this.taskService = (ITaskService)context.getService(this.taskServiceRef);
        if (this.taskService == null) {
            throw new IllegalStateException("Task service not available");
        }
        return this.taskService;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        try {
            result = this.doPush();
        }
        catch (IOException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error pushing git remote", (Throwable)e);
        }
        catch (CoreException e) {
            result = e.getStatus();
        }
        catch (JGitInternalException e) {
            result = this.getJGitInternalExceptionStatus(e, "Error pushing git remote");
        }
        catch (InvalidRemoteException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error pushing git remote", (Throwable)e);
        }
        catch (Exception e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error pushing git repository", (Throwable)e);
        }
        this.task.done(result);
        this.task.setMessage(NLS.bind((String)"Pushing {0} done", (Object)this.p.segment(0)));
        this.updateTask();
        this.taskService = null;
        GitActivator.getDefault().getBundleContext().ungetService(this.taskServiceRef);
        return Status.OK_STATUS;
    }

    private void updateTask() {
        this.getTaskService().updateTask(this.task);
    }
}

