/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.xfer.SFTPUserInfo;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SFTPTransferJob
extends Job {
    protected final String host;
    protected final File localRoot;
    private final List<String> options;
    protected final String passphrase;
    protected final int port;
    protected final IPath remoteRoot;
    protected TaskInfo task;
    private ITaskService taskService;
    private ServiceReference<ITaskService> taskServiceRef;
    protected final String user;

    public SFTPTransferJob(File localFile, String host, int port, IPath remotePath, String user, String passphrase, List<String> options) {
        super("Transfer over SFTP");
        this.localRoot = localFile;
        this.host = host;
        this.port = port;
        this.remoteRoot = remotePath;
        this.user = user;
        this.passphrase = passphrase;
        this.options = options;
        this.task = this.createTask();
    }

    private void cleanUp() {
        this.taskService = null;
        if (this.taskServiceRef != null) {
            Activator.getDefault().getContext().ungetService(this.taskServiceRef);
            this.taskServiceRef = null;
        }
    }

    protected TaskInfo createTask() {
        TaskInfo info = this.getTaskService().createTask();
        info.setMessage(NLS.bind((String)"Connecting to {0}...", (Object)this.host));
        this.getTaskService().updateTask(info);
        return info;
    }

    protected List<String> getOptions() {
        return this.options;
    }

    public TaskInfo getTask() {
        return this.task;
    }

    protected ITaskService getTaskService() {
        if (this.taskService == null) {
            BundleContext context = Activator.getDefault().getContext();
            if (this.taskServiceRef == null) {
                this.taskServiceRef = context.getServiceReference(ITaskService.class);
                if (this.taskServiceRef == null) {
                    throw new IllegalStateException("Task service not available");
                }
            }
            this.taskService = (ITaskService)context.getService(this.taskServiceRef);
            if (this.taskService == null) {
                throw new IllegalStateException("Task service not available");
            }
        }
        return this.taskService;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            JSch jsch = new JSch();
            Status result = null;
            try {
                Session session = jsch.getSession(this.user, this.host, this.port);
                session.setUserInfo((UserInfo)new SFTPUserInfo(this.passphrase, this.passphrase));
                session.connect();
                try {
                    ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
                    try {
                        channel.connect();
                        this.transferDirectory(channel, this.remoteRoot, this.localRoot);
                    }
                    finally {
                        channel.disconnect();
                    }
                }
                finally {
                    session.disconnect();
                }
            }
            catch (Exception e) {
                String msg = NLS.bind((String)"Transfer from {0} failed: {1}", (Object)(String.valueOf(this.host) + this.remoteRoot), (Object)e.getMessage());
                result = new Status(4, "org.eclipse.orion.server.servlets", msg, (Throwable)e);
            }
            if (result == null) {
                String msg = NLS.bind((String)"Transfer complete: {0}", (Object)(String.valueOf(this.host) + this.remoteRoot));
                result = new Status(0, "org.eclipse.orion.server.servlets", msg);
            }
            this.task.done((IStatus)result);
            this.getTaskService().updateTask(this.task);
            Status status = result;
            return status;
        }
        finally {
            this.cleanUp();
        }
    }

    protected void setTaskMessage(String message) {
        this.task.setMessage(message);
        this.getTaskService().updateTask(this.task);
    }

    protected boolean shouldSkip(String fileName) {
        if (".".equals(fileName) || "..".equals(fileName)) {
            return true;
        }
        return ".git".equals(fileName);
    }

    protected abstract void transferDirectory(ChannelSftp var1, IPath var2, File var3) throws SftpException, IOException;
}

