/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.configurator.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class WelcomeFileFilter
implements Filter {
    private static final String WELCOME_FILE_NAME = "index.html";
    private static final List<String> SERVLET_PATHS = Arrays.asList("/auth2", "/login", "/hosted", "/file", "/workspace/", "/filesystems", "/prefs", "/filesearch", "/git", "/users", "/site", "/xfer", "/help");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestURI = httpRequest.getRequestURI();
        if (requestURI.endsWith("/") && !this.isServletPath(requestURI)) {
            request.getRequestDispatcher(String.valueOf(requestURI) + WELCOME_FILE_NAME).forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isServletPath(String requestURI) {
        for (String prefix : SERVLET_PATHS) {
            if (!requestURI.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

