/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.form;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.form.Activator;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.authentication.form.httpcontext.BundleEntryHttpContext;
import org.eclipse.orion.server.authentication.form.servlets.AuthInitServlet;
import org.eclipse.orion.server.authentication.form.servlets.LoginFormServlet;
import org.eclipse.orion.server.authentication.form.servlets.LoginServlet;
import org.eclipse.orion.server.authentication.form.servlets.LogoutServlet;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class FormAuthenticationService
implements IAuthenticationService {
    public static final String CSS_LINK_PROPERTY = "STYLES";
    private Properties defaultAuthenticationProperties;
    private HttpService httpService;

    public Properties getDefaultAuthenticationProperties() {
        return this.defaultAuthenticationProperties;
    }

    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(req, resp, properties);
        }
        return user;
    }

    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String username = FormAuthHelper.getAuthenticatedUser((HttpServletRequest)req);
        if (username != null) {
            return username;
        }
        return null;
    }

    public String getAuthType() {
        return "FORM";
    }

    public void configure(Properties properties) {
        this.defaultAuthenticationProperties = properties;
        try {
            this.httpService.registerServlet("/auth2", (Servlet)new AuthInitServlet(properties), null, (HttpContext)new BundleEntryHttpContext(Activator.getBundleContext().getBundle()));
        }
        catch (Exception exception) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.authentication.form", "Reconfiguring FormAutneticationService"));
            try {
                this.httpService.unregister("/auth2");
                this.httpService.registerServlet("/auth2", (Servlet)new AuthInitServlet(properties), null, (HttpContext)new BundleEntryHttpContext(Activator.getBundleContext().getBundle()));
            }
            catch (ServletException e1) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.form", 1, "An error occured when registering servlets", (Throwable)e1));
            }
            catch (NamespaceException e1) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.form", 1, "A namespace error occured when registering servlets", (Throwable)e1));
            }
            catch (IllegalArgumentException e1) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.form", 1, "FormAuthenticationService could not be configured", (Throwable)e1));
            }
        }
    }

    private void setNotAuthenticated(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        if (properties == null) {
            properties = new Properties();
        }
        resp.setHeader("WWW-Authenticate", this.getAuthType());
        resp.setStatus(401);
        String putStyle = properties.getProperty(CSS_LINK_PROPERTY) == null ? "" : "&styles=" + properties.getProperty(CSS_LINK_PROPERTY);
        RequestDispatcher rd = req.getRequestDispatcher("/loginform/login?redirect=" + req.getRequestURI() + putStyle);
        try {
            try {
                rd.forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (ServletException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            resp.flushBuffer();
        }
    }

    public void setHttpService(HttpService hs) {
        this.httpService = hs;
        BundleEntryHttpContext httpContext = new BundleEntryHttpContext(Activator.getBundleContext().getBundle());
        try {
            this.httpService.registerServlet("/login", (Servlet)new LoginServlet(), null, (HttpContext)httpContext);
            this.httpService.registerServlet("/logout", (Servlet)new LogoutServlet(), null, (HttpContext)httpContext);
            this.httpService.registerServlet("/loginform", (Servlet)new LoginFormServlet(), null, (HttpContext)httpContext);
            this.httpService.registerResources("/loginstatic", "/web", (HttpContext)httpContext);
        }
        catch (ServletException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.form", 1, "An error occured when registering servlets", (Throwable)e));
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication.form", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService hs) {
        this.httpService.unregister("/login");
        this.httpService.unregister("/logout");
        this.httpService.unregister("/loginform");
        this.httpService.unregister("/loginstatic");
        this.httpService = null;
    }
}

