/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.form.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.orion.server.authentication.form.Activator;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.osgi.framework.Version;

public class LoginFormServlet
extends HttpServlet {
    private static final long serialVersionUID = -7686742575461695377L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        if (!resp.isCommitted()) {
            String versionString = req.getHeader("Orion-Version");
            Version version = versionString == null ? null : new Version(versionString);
            String xRequestedWith = req.getHeader("X-Requested-With");
            if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
                this.writeHtmlResponse(req, resp);
            } else {
                this.writeJavaScriptResponse(req, resp);
            }
        }
    }

    private void writeJavaScriptResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/javascript");
        PrintWriter writer = resp.getWriter();
        writer.print("if(!stylg)\n");
        writer.print("var stylg=document.createElement(\"link\");");
        writer.print("stylg.setAttribute(\"rel\", \"stylesheet\");");
        writer.print("stylg.setAttribute(\"type\", \"text/css\");");
        writer.print("stylg.setAttribute(\"href\", \"");
        writer.print(this.getStyles(req.getParameter("styles")));
        writer.print("\");");
        writer.print("if(!divg)\n");
        writer.print("var divg = document.createElement(\"span\");\n");
        writer.print("divg.innerHTML='");
        writer.print(this.loadJSResponse(req));
        writer.print("setUserStore('");
        writer.print(FormAuthHelper.getDefaultUserAdmin().getStoreName());
        writer.print("');");
        String path = req.getPathInfo();
        if (path.startsWith("/login")) {
            writer.print("login();");
        } else if (path.startsWith("/checkuser")) {
            writer.print("checkUser();");
        }
        writer.flush();
    }

    private String getStyles(String stylesParam) {
        if (stylesParam == null || stylesParam.length() == 0) {
            return "/loginstatic/css/defaultLoginWindow.css";
        }
        return stylesParam.replaceAll("'", "\\\\'").replaceAll("\\t+", " ").replaceAll("\n", "");
    }

    private String loadJSResponse(HttpServletRequest req) throws IOException {
        StringBuilder sb = new StringBuilder();
        StringBuilder authString = new StringBuilder();
        this.appendFileContentAsJsString(authString, "web/auth.html");
        String authSite = this.replaceNewAccount(authString.toString(), req.getHeader("Referer"), true);
        authSite = this.replaceError(authSite, "");
        authSite = this.replaceUserStores(authSite, true);
        sb.append(authSite);
        sb.append("';\n");
        sb.append("var scr = '");
        this.appendFileContentAsJsString(sb, "web/js/xhrAuth.js");
        sb.append("';\n");
        sb.append(this.getFileContents("web/js/loadXhrAuth.js"));
        return sb.toString();
    }

    private String getFileContents(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStream is = Activator.getBundleContext().getBundle().getEntry(filename).openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = "";
        while ((line = br.readLine()) != null) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private String getFileContentAsJsString(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.appendFileContentAsJsString(sb, filename);
        return sb.toString();
    }

    private void appendFileContentAsJsString(StringBuilder sb, String filename) throws IOException {
        InputStream is = Activator.getBundleContext().getBundle().getEntry(filename).openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = "";
        while ((line = br.readLine()) != null) {
            line = line.replaceAll("'", "\\\\'");
            line = line.replaceAll("\\t+", " ");
            sb.append(line);
        }
    }

    private void writeHtmlResponse(HttpServletRequest req, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<meta name=\"copyright\" content=\"Copyright (c) IBM Corporation and others 2010.\" >");
        writer.println("<meta http-equiv=\"Content-Language\" content=\"en-us\">");
        writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">");
        writer.println("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=8\">");
        writer.println("<title>Login Page</title>");
        if (req.getParameter("styles") == null || "".equals(req.getParameter("styles"))) {
            writer.println("<style type=\"text/css\">");
            writer.print("@import \"");
            writer.print("/loginstatic/css/defaultLoginWindow.css");
            writer.print("\";");
            writer.println("</style>");
        } else {
            writer.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            writer.print(req.getParameter("styles"));
            writer.print("\">");
        }
        writer.println("<script type=\"text/javascript\"><!--");
        writer.println("function confirm() {}");
        writer.println(this.getFileContents("web/js/htmlAuth.js"));
        writer.println("//--></script>");
        writer.println("</head>");
        writer.print("<body onLoad=\"javascript:setUserStore('");
        writer.print(FormAuthHelper.getDefaultUserAdmin().getStoreName());
        writer.println("');\">");
        String authSite = this.getFileContents("web/auth.html");
        authSite = this.replaceForm(authSite, req.getParameter("redirect"));
        authSite = this.replaceNewAccount(authSite, req.getParameter("redirect") == null ? req.getRequestURI() : req.getParameter("redirect"), false);
        authSite = this.replaceError(authSite, req.getParameter("error"));
        authSite = this.replaceUserStores(authSite, false);
        writer.println(authSite);
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
    }

    private String replaceError(String authSite, String error) {
        if (error == null) {
            error = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"errorWin\"");
        if (error.trim().length() == 0) {
            sb.append(" style=\"display: none\"");
        }
        sb.append(">");
        sb.append("<ul id=\"loginError\">");
        sb.append("<li id=\"errorMessage\">");
        sb.append(new String(Base64.decode((byte[])error.getBytes())));
        sb.append("</li></ul>");
        sb.append("</div>");
        return authSite.replaceAll("<!--ERROR-->", sb.toString());
    }

    private String replaceForm(String authSite, String redirect) {
        StringBuilder formBegin = new StringBuilder();
        formBegin.append("<form name=\"AuthForm\" method=post action=\"/login");
        if (redirect != null && !redirect.equals("")) {
            formBegin.append("?redirect=");
            formBegin.append(redirect);
        }
        formBegin.append("\">");
        formBegin.append("<input id=\"store\" name=\"store\" type=\"hidden\" value=\"" + FormAuthHelper.getDefaultUserAdmin().getStoreName() + "\">");
        return authSite.replace("<!--form-->", formBegin.toString()).replace("<!--/form-->", "</form>");
    }

    private String replaceCreateUserForm(String authSite, String redirect) {
        StringBuilder formBegin = new StringBuilder();
        formBegin.append("<form name=\"CreateUserForm\" onsubmit=\"return validatePasswords()\" method=post action=\"/users");
        if (redirect != null && !redirect.equals("")) {
            formBegin.append("?redirect=");
            formBegin.append(redirect);
        }
        formBegin.append("\">");
        return authSite.replace("<!--form-->", formBegin.toString()).replace("<!--/form-->", "</form>");
    }

    private String replaceNewAccount(String authSite, String redirect, boolean javascriptResp) throws IOException {
        if (!FormAuthHelper.canAddUsers()) {
            return authSite;
        }
        String newAccountA = javascriptResp ? this.getFileContentAsJsString("web/createUser.html") : this.getFileContents("web/createUser.html");
        Collection stores = FormAuthHelper.getSupportedUserStores();
        String userStore = FormAuthHelper.getDefaultUserAdmin().getStoreName();
        newAccountA = newAccountA.replaceAll("<!--userStore-->", stores.size() < 2 ? "" : userStore);
        newAccountA = newAccountA.replaceAll("<!--userStoreValue-->", userStore);
        if (!javascriptResp) {
            newAccountA = this.replaceCreateUserForm(newAccountA, redirect);
        }
        return authSite.replace("<!--NEW_ACCOUNT_LINK-->", newAccountA);
    }

    private String replaceUserStores(String authSite, boolean isJsResponce) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        Collection stores = FormAuthHelper.getSupportedUserStores();
        if (stores == null || stores.size() < 2) {
            return authSite;
        }
        for (String store : stores) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(" | ");
            }
            if (isJsResponce) {
                sb.append("<a class=\"loginWindowStores\" href=\"javascript:setUserStore(\\\\'");
            } else {
                sb.append("<a class=\"loginWindowStores\" href=\"javascript:setUserStore('");
            }
            sb.append(store);
            if (isJsResponce) {
                sb.append("\\\\')\" id=\"Login_");
            } else {
                sb.append("')\" id=\"Login_");
            }
            sb.append(store);
            sb.append("\">");
            sb.append(store);
            sb.append("</a>");
        }
        return authSite.replaceAll("<!--LOGIN STORES-->", sb.toString());
    }
}

