/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.orion.internal.server.hosting.HostingActivator;
import org.eclipse.orion.internal.server.servlets.hosting.ISiteHostingService;

public class HostedSiteRequestFilter
implements Filter {
    private static final String HOSTED_SITE_ALIAS = "/hosted";
    private ISiteHostingService siteHostingService;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.siteHostingService = HostingActivator.getDefault().getHostingService();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq;
        String host;
        if (this.siteHostingService != null && (host = HostedSiteRequestFilter.getHost(httpReq = (HttpServletRequest)req)) != null) {
            String requestUri = httpReq.getRequestURI();
            if (this.siteHostingService.isHosted(host) && !requestUri.startsWith(HOSTED_SITE_ALIAS)) {
                RequestDispatcher rd = httpReq.getRequestDispatcher("/hosted/" + host + requestUri);
                rd.forward(req, resp);
                return;
            }
        }
        chain.doFilter(req, resp);
    }

    private static String getHost(HttpServletRequest req) {
        return req.getHeader("Host");
    }

    public void destroy() {
    }
}

