/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.hosting.HostingActivator;
import org.eclipse.orion.internal.server.hosting.SiteHostingService;
import org.eclipse.orion.internal.server.servlets.hosting.IHostedSite;
import org.eclipse.orion.internal.server.servlets.site.SiteConfiguration;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;
import org.eclipse.orion.server.core.LogHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HostedStatusDecorator
implements IWebResourceDecorator {
    private static final String SITE_CONFIGURATION_SERVLET_ALIAS = "site";

    public void addAtributesFor(HttpServletRequest req, URI resource, JSONObject representation) {
        Path resourcePath = new Path(resource.getPath());
        if (resourcePath.segmentCount() == 0) {
            return;
        }
        String service = resourcePath.segment(0);
        if (!SITE_CONFIGURATION_SERVLET_ALIAS.equals(service)) {
            return;
        }
        try {
            WebUser webUser = HostedStatusDecorator.getWebUser(req);
            if (resourcePath.segmentCount() == 1) {
                if ("GET".equals(req.getMethod())) {
                    JSONArray siteConfigurations = representation.optJSONArray("SiteConfigurations");
                    if (siteConfigurations != null) {
                        int i = 0;
                        while (i < siteConfigurations.length()) {
                            this.addStatus(siteConfigurations.getJSONObject(i), webUser, resource);
                            ++i;
                        }
                    }
                } else if ("POST".equals(req.getMethod())) {
                    this.addStatus(representation, webUser, resource);
                }
            } else if (resourcePath.segmentCount() == 2) {
                this.addStatus(representation, webUser, resource);
            }
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
        }
    }

    private static WebUser getWebUser(HttpServletRequest req) {
        String remoteUser = req.getRemoteUser();
        if (remoteUser != null) {
            return WebUser.fromUserName((String)remoteUser);
        }
        return null;
    }

    private void addStatus(JSONObject siteConfigJson, WebUser user, URI resource) throws JSONException {
        String id = siteConfigJson.getString("Id");
        SiteConfiguration siteConfiguration = SiteConfiguration.fromId((String)id);
        SiteHostingService hostingService = HostingActivator.getDefault().getHostingService();
        IHostedSite site = hostingService.get(siteConfiguration, user);
        JSONObject hostingStatus = new JSONObject();
        if (site != null) {
            hostingStatus.put("Status", (Object)"started");
            String hostedUrl = String.valueOf(resource.getScheme()) + "://" + site.getHost();
            hostingStatus.put("URL", (Object)hostedUrl);
        } else {
            hostingStatus.put("Status", (Object)"stopped");
        }
        siteConfigJson.put("HostingStatus", (Object)hostingStatus);
    }
}

