/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.site;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.site.SiteConfiguration;
import org.eclipse.orion.internal.server.servlets.site.SiteConfigurationResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONObject;

public class SiteConfigurationServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    private ServletResourceHandler<SiteConfiguration> siteConfigurationResourceHandler = new SiteConfigurationResourceHandler(this.getStatusHandler());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        IPath pathInfo = SiteConfigurationServlet.getPathInfo(req);
        if (pathInfo.segmentCount() == 0) {
            this.doGetAllSiteConfigurations(req, resp);
            return;
        }
        if (pathInfo.segmentCount() == 1) {
            SiteConfiguration site = this.getExistingSiteConfig(req, resp);
            if (this.siteConfigurationResourceHandler.handleRequest(req, resp, site)) {
                return;
            }
        } else {
            this.handleException(resp, (IStatus)new ServerStatus(4, 400, "Bad request", null));
            return;
        }
        super.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        IPath pathInfo = SiteConfigurationServlet.getPathInfo(req);
        if (pathInfo.segmentCount() == 0) {
            if (this.siteConfigurationResourceHandler.handleRequest(req, resp, null)) {
                return;
            }
        } else {
            this.handleException(resp, (IStatus)new ServerStatus(4, 400, "Bad request", null));
            return;
        }
        super.doPost(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        IPath pathInfo = SiteConfigurationServlet.getPathInfo(req);
        if (pathInfo.segmentCount() == 1) {
            SiteConfiguration site = this.getExistingSiteConfig(req, resp);
            if (this.siteConfigurationResourceHandler.handleRequest(req, resp, site)) {
                return;
            }
        } else {
            this.handleException(resp, (IStatus)new ServerStatus(4, 400, "Bad request", null));
            return;
        }
        super.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        if (SiteConfigurationServlet.getPathInfo(req).segmentCount() == 1) {
            SiteConfiguration site = this.getExistingSiteConfig(req, resp);
            if (this.siteConfigurationResourceHandler.handleRequest(req, resp, site)) {
                return;
            }
        } else {
            this.handleException(resp, (IStatus)new ServerStatus(4, 400, "Bad request", null));
        }
        super.doDelete(req, resp);
    }

    private SiteConfiguration getExistingSiteConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String userName = SiteConfigurationServlet.getUserName(req);
        WebUser user = WebUser.fromUserName(userName);
        IPath pathInfo = SiteConfigurationServlet.getPathInfo(req);
        if (pathInfo.segmentCount() == 1) {
            return user.getSiteConfiguration(pathInfo.segment(0));
        }
        return null;
    }

    private boolean doGetAllSiteConfigurations(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String userName = SiteConfigurationServlet.getUserName(req);
        try {
            WebUser user = WebUser.fromUserName(userName);
            JSONArray siteConfigurations = user.getSiteConfigurationsJSON(ServletResourceHandler.getURI(req));
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put("SiteConfigurations", (Object)siteConfigurations);
            SiteConfigurationServlet.writeJSONResponse(req, resp, jsonResponse);
        }
        catch (Exception e) {
            this.handleException(resp, "An error occurred while obtaining site configurations", e);
        }
        return true;
    }

    private static IPath getPathInfo(HttpServletRequest req) {
        String pathString = req.getPathInfo();
        if (pathString == null) {
            return new Path("");
        }
        return new Path(pathString);
    }

    private static String getUserName(HttpServletRequest req) {
        return req.getRemoteUser();
    }
}

