/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.authentication.form.core.FormAuthHelper;
import org.eclipse.orion.server.authentication.formopenid.FormOpenIdAuthenticationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.openid.core.OpenIdHelper;
import org.eclipse.orion.server.openid.core.OpenidConsumer;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.useradmin.UnsupportedUserStoreException;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class FormOpenIdLoginServlet
extends OrionServlet {
    private FormOpenIdAuthenticationService authenticationService;
    private OpenidConsumer consumer;
    private static final long serialVersionUID = 1L;

    public FormOpenIdLoginServlet(FormOpenIdAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String user;
        String pathInfo;
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/form")) {
            block19: {
                try {
                    if (FormAuthHelper.performAuthentication((HttpServletRequest)req, (HttpServletResponse)resp)) {
                        if (req.getParameter("redirect") != null && !req.getParameter("redirect").equals("")) {
                            resp.sendRedirect(req.getParameter("redirect"));
                        } else {
                            resp.flushBuffer();
                        }
                        break block19;
                    }
                    String versionString = req.getHeader("Orion-Version");
                    Version version = versionString == null ? null : new Version(versionString);
                    String xRequestedWith = req.getHeader("X-Requested-With");
                    String invalidLoginError = "Invalid user or password";
                    if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
                        RequestDispatcher rd = req.getRequestDispatcher("/mixlogin?error=" + new String(Base64.encode((byte[])invalidLoginError.getBytes())));
                        rd.include((ServletRequest)req, (ServletResponse)resp);
                    } else {
                        resp.setStatus(401);
                        PrintWriter writer = resp.getWriter();
                        JSONObject jsonError = new JSONObject();
                        try {
                            jsonError.put("error", (Object)invalidLoginError);
                            writer.print(jsonError);
                            resp.setContentType("application/json");
                        }
                        catch (JSONException jSONException) {}
                    }
                    resp.flushBuffer();
                }
                catch (UnsupportedUserStoreException e) {
                    LogHelper.log((Throwable)e);
                    resp.sendError(404, e.getMessage());
                }
            }
            return;
        }
        if (pathInfo.startsWith("/openid")) {
            String openid = req.getParameter("openid");
            if (openid != null) {
                this.consumer = OpenIdHelper.redirectToOpenIdProvider((HttpServletRequest)req, (HttpServletResponse)resp, (OpenidConsumer)this.consumer);
                return;
            }
            String op_return = req.getParameter("op_return");
            if (op_return != null) {
                OpenIdHelper.handleOpenIdReturn((HttpServletRequest)req, (HttpServletResponse)resp, (OpenidConsumer)this.consumer);
                return;
            }
        }
        if ((user = this.authenticationService.getAuthenticatedUser(req, resp, this.authenticationService.getDefaultAuthenticationProperties())) != null) {
            resp.setStatus(200);
            try {
                JSONObject array = new JSONObject();
                array.put("login", (Object)user);
                try {
                    IOrionUserProfileNode generalUserProfile = FormAuthHelper.getUserProfileService().getUserProfileNode(user, "general");
                    Long lastLogin = Long.parseLong(generalUserProfile.get("lastlogintimestamp", ""));
                    array.put("lastlogintimestamp", (Object)lastLogin);
                }
                catch (IllegalArgumentException e) {
                    LogHelper.log((Throwable)e);
                }
                catch (CoreException e) {
                    LogHelper.log((Throwable)e);
                }
                resp.getWriter().print(array.toString());
            }
            catch (JSONException e) {
                this.handleException(resp, "An error occured when creating JSON object for logged in user", (Exception)((Object)e));
            }
            return;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo;
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/openid") && (req.getParameter("openid") != null || req.getParameter("op_return") != null)) {
            this.doPost(req, resp);
            return;
        }
        RequestDispatcher rd = req.getRequestDispatcher("/mixlogin/login");
        rd.forward((ServletRequest)req, (ServletResponse)resp);
    }
}

