/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.openid.core;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.openid.core.OpenidConsumer;
import org.json.JSONException;
import org.json.JSONObject;
import org.openid4java.consumer.ConsumerException;

public class OpenIdHelper {
    public static final String OPENID = "openid";
    public static final String OP_RETURN = "op_return";
    public static final String REDIRECT = "redirect";
    static final String OPENID_IDENTIFIER = "openid_identifier";
    static final String OPENID_DISC = "openid-disc";

    public static String getAuthenticatedUser(HttpServletRequest req) throws IOException {
        HttpSession s = req.getSession(true);
        if (s.getAttribute(OPENID_IDENTIFIER) != null) {
            return (String)s.getAttribute(OPENID_IDENTIFIER);
        }
        return null;
    }

    public static OpenidConsumer redirectToOpenIdProvider(HttpServletRequest req, HttpServletResponse resp, OpenidConsumer consumer) throws IOException {
        String redirect = req.getParameter(REDIRECT);
        try {
            StringBuffer sb = OpenIdHelper.getRequestServer(req);
            sb.append(String.valueOf(req.getServletPath()) + (req.getPathInfo() == null ? "" : req.getPathInfo()));
            sb.append("?").append(OP_RETURN).append("=true");
            if (redirect != null && redirect.length() > 0) {
                sb.append("&").append(REDIRECT).append("=");
                sb.append(redirect);
            }
            consumer = new OpenidConsumer(sb.toString());
            consumer.authRequest(req.getParameter(OPENID), req, resp);
        }
        catch (ConsumerException e) {
            OpenIdHelper.writeOpenIdError(e.getMessage(), req, resp);
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.authentication.openid.core", "An error occured when creating OpenidConsumer", (Throwable)e));
        }
        catch (CoreException e) {
            OpenIdHelper.writeOpenIdError(e.getMessage(), req, resp);
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.authentication.openid.core", "An error occured when authenticing request", (Throwable)e));
        }
        return consumer;
    }

    private static void writeOpenIdError(String error, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(REDIRECT) == null) {
            PrintWriter out = resp.getWriter();
            out.println("<html><head></head>");
            out.print("<body onload=\"window.opener.handleOpenIDResponse((window.location+'').split('?')[1],'");
            out.print(error);
            out.println("');window.close();\">");
            out.println("</body>");
            out.println("</html>");
            out.close();
            return;
        }
        PrintWriter out = resp.getWriter();
        out.println("<html><head></head>");
        String url = req.getParameter(REDIRECT);
        url = url.replaceAll("/&error(\\=[^&]*)?(?=&|$)|^error(\\=[^&]*)?(&|$)/", "");
        out.print("<body onload=\"window.location.replace('");
        out.print(url.toString());
        if (url.contains("?")) {
            out.print("&error=");
        } else {
            out.print("?error=");
        }
        out.print(new String(Base64.encode((byte[])error.getBytes())));
        out.println("');\">");
        out.println("</body>");
        out.println("</html>");
    }

    public static void handleOpenIdReturn(HttpServletRequest req, HttpServletResponse resp, OpenidConsumer consumer) throws IOException {
        String redirect = req.getParameter(REDIRECT);
        String op_return = req.getParameter(OP_RETURN);
        if (Boolean.parseBoolean(op_return) && consumer != null) {
            consumer.verifyResponse(req);
            if (redirect != null) {
                resp.sendRedirect(redirect);
                return;
            }
            PrintWriter out = resp.getWriter();
            out.println("<html><head></head>");
            out.println("<body onload=\"window.opener.handleOpenIDResponse((window.location+'').split('?')[1]);window.close();\">");
            out.println("</body>");
            out.println("</html>");
            out.close();
            return;
        }
    }

    private static StringBuffer getRequestServer(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        return url;
    }

    public static void performLogout(HttpServletRequest req) {
        HttpSession s = req.getSession(true);
        if (s.getAttribute(OPENID_IDENTIFIER) != null) {
            s.removeAttribute(OPENID_IDENTIFIER);
        }
    }

    public static void writeLoginResponse(String login, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        try {
            JSONObject array = new JSONObject();
            array.put("login", (Object)login);
            resp.getWriter().print(array.toString());
        }
        catch (JSONException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.authentication.openid.core", "An error occured when creating JSON object for logged in user", (Throwable)e));
        }
    }

    public static String getAuthType() {
        return "OpenId";
    }
}

