/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class BaseToCommitConverter {
    public static final BaseToCommitConverter FILE = new BaseToCommitConverter(){

        @Override
        public URI baseToCommitLocation(URI base, String commit) throws URISyntaxException {
            Path p = new Path(base.getPath());
            p = new Path("/gitapi").append("commit").append(commit).addTrailingSeparator().append((IPath)p);
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), p.toString(), base.getQuery(), base.getFragment());
        }
    };
    public static final BaseToCommitConverter REMOVE_FIRST_2 = new BaseToCommitConverter(){

        @Override
        public URI baseToCommitLocation(URI base, String commit) throws URISyntaxException {
            Path p = new Path(base.getPath());
            p = p.uptoSegment(1).append("commit").append(commit).addTrailingSeparator().append(p.removeFirstSegments(2));
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), p.toString(), base.getQuery(), base.getFragment());
        }
    };
    public static final BaseToCommitConverter REMOVE_FIRST_3 = new BaseToCommitConverter(){

        @Override
        public URI baseToCommitLocation(URI base, String commit) throws URISyntaxException {
            Path p = new Path(base.getPath());
            p = p.uptoSegment(1).append("commit").append(commit).addTrailingSeparator().append(p.removeFirstSegments(3));
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), p.toString(), base.getQuery(), base.getFragment());
        }
    };
    public static final BaseToCommitConverter REMOVE_FIRST_4 = new BaseToCommitConverter(){

        @Override
        public URI baseToCommitLocation(URI base, String commit) throws URISyntaxException {
            Path p = new Path(base.getPath());
            p = p.uptoSegment(1).append("commit").append(commit).addTrailingSeparator().append(p.removeFirstSegments(4));
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), p.toString(), base.getQuery(), base.getFragment());
        }
    };

    public static URI getCommitLocation(URI base, String commit, BaseToCommitConverter converter) throws IOException, URISyntaxException {
        return converter.baseToCommitLocation(base, commit);
    }

    protected abstract URI baseToCommitLocation(URI var1, String var2) throws URISyntaxException;
}

