/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.git.GitActivator;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.servlets.GitJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class FetchJob
extends GitJob {
    private final TaskInfo task;
    private ITaskService taskService;
    private ServiceReference<ITaskService> taskServiceRef;
    private IPath path;
    private String remote;

    public FetchJob(CredentialsProvider credentials, Path path) {
        super("Fetching", (GitCredentialsProvider)credentials);
        this.path = path;
        this.remote = path.segment(0);
        this.task = this.createTask();
    }

    private TaskInfo createTask() {
        TaskInfo info = this.getTaskService().createTask();
        info.setMessage(NLS.bind((String)"Fetching {0}...", (Object)this.remote));
        this.getTaskService().updateTask(info);
        return info;
    }

    private void doFetch() throws IOException, CoreException, JGitInternalException, InvalidRemoteException, URISyntaxException {
        Repository db = this.getRepository();
        String branch = this.getRemoteBranch();
        Git git = new Git(db);
        FetchCommand fc = git.fetch();
        RemoteConfig remoteConfig = new RemoteConfig((Config)git.getRepository().getConfig(), this.remote);
        this.credentials.setUri((URIish)remoteConfig.getURIs().get(0));
        fc.setCredentialsProvider((CredentialsProvider)this.credentials);
        fc.setRemote(this.remote);
        if (branch != null) {
            RefSpec spec = new RefSpec("refs/heads/" + branch + ":" + "refs/remotes/" + this.remote + "/" + branch);
            fc.setRefSpecs(new RefSpec[]{spec});
        }
        fc.call();
    }

    private Repository getRepository() throws IOException, CoreException {
        IPath p = null;
        p = this.path.segment(1).equals("file") ? this.path.removeFirstSegments(1) : this.path.removeFirstSegments(2);
        return new FileRepository(GitUtils.getGitDir(p));
    }

    private String getRemoteBranch() {
        if (this.path.segment(1).equals("file")) {
            return null;
        }
        return this.path.segment(1);
    }

    public TaskInfo getTask() {
        return this.task;
    }

    private ITaskService getTaskService() {
        BundleContext context = GitActivator.getDefault().getBundleContext();
        this.taskServiceRef = context.getServiceReference(ITaskService.class);
        if (this.taskServiceRef == null) {
            throw new IllegalStateException("Task service not available");
        }
        this.taskService = (ITaskService)context.getService(this.taskServiceRef);
        if (this.taskService == null) {
            throw new IllegalStateException("Task service not available");
        }
        return this.taskService;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        try {
            this.doFetch();
        }
        catch (IOException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error fetching git remote", (Throwable)e);
        }
        catch (CoreException e) {
            result = e.getStatus();
        }
        catch (JGitInternalException e) {
            result = this.getJGitInternalExceptionStatus(e, "An internal git error fetching git remote");
        }
        catch (InvalidRemoteException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error fetching git remote", (Throwable)e);
        }
        catch (Exception e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error fetching git remote", (Throwable)e);
        }
        this.task.done(result);
        this.task.setMessage(NLS.bind((String)"Fetching {0} done", (Object)this.remote));
        this.updateTask();
        this.taskService = null;
        GitActivator.getDefault().getBundleContext().ungetService(this.taskServiceRef);
        return Status.OK_STATUS;
    }

    private void updateTask() {
        this.getTaskService().updateTask(this.task);
    }
}

