/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.workspace.WebProjectResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.internal.server.servlets.workspace.WorkspaceResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.servlets.CloneJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.git.servlets.WebClone;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitCloneHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitCloneHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        try {
            switch (GitCloneHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleGet(request, response, path);
                }
                case PUT: {
                    return this.handlePut(request, response, path);
                }
                case POST: {
                    return this.handlePost(request, response);
                }
                case DELETE: {
                    return this.handleDelete(request, response, path);
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to handle /git/clone request for {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return false;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response) throws IOException, JSONException, ServletException, URISyntaxException, CoreException, NoHeadException, NoMessageException, ConcurrentRefUpdateException, JGitInternalException, WrongRepositoryStateException {
        Path path;
        boolean initOnly;
        JSONObject toAdd = OrionServlet.readJSONRequest((HttpServletRequest)request);
        WebClone clone = new WebClone();
        String url = toAdd.optString("GitUrl", null);
        if (url == null || url.isEmpty()) {
            initOnly = true;
        } else {
            initOnly = false;
            if (!this.validateCloneUrl(url, request, response)) {
                return true;
            }
            clone.setUrl(new URIish(url));
        }
        String cloneName = toAdd.optString("Name", null);
        if (cloneName == null) {
            cloneName = request.getHeader("Slug");
        }
        String workspacePath = toAdd.optString("Location", null);
        String filePath = toAdd.optString("Path", null);
        if (filePath == null && workspacePath == null) {
            String msg = NLS.bind((String)"Either 'Path' or 'Location' should be provided: {0}", (Object)toAdd);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
        }
        if (initOnly && filePath == null && cloneName == null) {
            String msg = NLS.bind((String)"Either 'Path' or 'GitName' should be provided: {0}", (Object)toAdd);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
        }
        if (!this.validateCloneName(cloneName, request, response)) {
            return true;
        }
        WebProject webProject = null;
        boolean webProjectExists = false;
        if (filePath != null) {
            path = new Path(filePath);
            clone.setId(path.removeFirstSegments(1).toString());
            webProject = WebProject.fromId((String)path.segment(1));
            webProjectExists = WebProject.exists((String)path.segment(1));
            clone.setContentLocation(webProject.getProjectStore().getFileStore(path.removeFirstSegments(2)).toURI());
            if (cloneName == null) {
                cloneName = path.segmentCount() > 2 ? path.lastSegment() : webProject.getName();
            }
        } else if (workspacePath != null) {
            path = new Path(workspacePath);
            String id = WebProject.nextProjectId();
            webProjectExists = false;
            webProject = WebProject.fromId((String)id);
            if (cloneName == null) {
                cloneName = new URIish(url).getHumanishName();
            }
            webProject.setName(cloneName);
            try {
                WorkspaceResourceHandler.computeProjectLocation((WebProject)webProject, null, (String)request.getRemoteUser(), (boolean)false);
            }
            catch (CoreException e) {
                String msg = NLS.bind((String)"Server content location could not be written: {0}", (Object)Activator.getDefault().getRootLocationURI());
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
            }
            catch (URISyntaxException uRISyntaxException) {}
            WebWorkspace workspace = WebWorkspace.fromId((String)path.segment(1));
            workspace.addProject(webProject);
            try {
                webProject.save();
                workspace.save();
            }
            catch (CoreException e) {
                String msg = "Error persisting project state";
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
            }
            URI baseLocation = GitCloneHandlerV1.getURI((HttpServletRequest)request);
            baseLocation = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), workspacePath, baseLocation.getQuery(), baseLocation.getFragment());
            JSONObject jsonProject = WebProjectResourceHandler.toJSON((WebProject)webProject, (URI)baseLocation);
            this.addProjectRights(request, response, jsonProject.optString("Location"));
            this.addProjectRights(request, response, jsonProject.optString("ContentLocation"));
            clone.setId(webProject.getId());
            clone.setContentLocation(webProject.getProjectStore().toURI());
        }
        clone.setName(cloneName);
        if (initOnly) {
            InitCommand command = new InitCommand();
            File directory = new File(clone.getContentLocation());
            command.setDirectory(directory);
            Repository repository = command.call().getRepository();
            Git git = new Git(repository);
            GitCloneHandlerV1.doConfigureClone(git, request.getRemoteUser());
            git.commit().setMessage("Initial commit").call();
            JSONObject result = WebClone.toJSON(clone, GitCloneHandlerV1.getURI((HttpServletRequest)request));
            String cloneLocation = result.getString("Location");
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            response.setHeader("Location", cloneLocation);
            response.setStatus(201);
            return true;
        }
        String username = toAdd.optString("GitSshUsername", null);
        char[] password = toAdd.optString("GitSshPassword", "").toCharArray();
        String knownHosts = toAdd.optString("GitSshKnownHost", null);
        byte[] privateKey = toAdd.optString("GitSshPrivateKey", "").getBytes();
        byte[] publicKey = toAdd.optString("GitSshPublicKey", "").getBytes();
        byte[] passphrase = toAdd.optString("GitSshPassphrase", "").getBytes();
        GitCredentialsProvider cp = new GitCredentialsProvider(new URIish(clone.getUrl()), username, password, knownHosts);
        cp.setPrivateKey(privateKey);
        cp.setPublicKey(publicKey);
        cp.setPassphrase(passphrase);
        JSONObject cloneObject = WebClone.toJSON(clone, GitCloneHandlerV1.getURI((HttpServletRequest)request));
        String cloneLocation = cloneObject.getString("Location");
        CloneJob job = new CloneJob(clone, (CredentialsProvider)cp, request.getRemoteUser(), cloneLocation, webProjectExists ? null : webProject);
        job.schedule();
        TaskInfo task = job.getTask();
        JSONObject result = task.toJSON();
        String taskLocation = GitCloneHandlerV1.getURI((HttpServletRequest)request).resolve("../../task/id/" + task.getTaskId()).toString();
        result.put("Location", (Object)taskLocation);
        response.setHeader("Location", taskLocation);
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
        response.setStatus(202);
        return true;
    }

    static void doConfigureClone(Git git, String user) throws IOException, CoreException {
        StoredConfig config = git.getRepository().getConfig();
        IOrionUserProfileNode userNode = UserServiceHelper.getDefault().getUserProfileService().getUserProfileNode(user, true).getUserProfileNode("general");
        if (userNode.get("GitName", null) != null) {
            config.setString("user", null, "name", userNode.get("GitName", null));
        }
        if (userNode.get("GitMail", null) != null) {
            config.setString("user", null, "email", userNode.get("GitMail", null));
        }
        config.setBoolean("core", null, "filemode", false);
        config.save();
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String pathString) throws IOException, JSONException, ServletException, URISyntaxException, CoreException {
        Path path = pathString == null ? Path.EMPTY : new Path(pathString);
        URI baseLocation = GitCloneHandlerV1.getURI((HttpServletRequest)request);
        String user = request.getRemoteUser();
        if (path.segment(0).equals("workspace") && path.segmentCount() == 2) {
            if (WebWorkspace.exists((String)path.segment(1))) {
                WebWorkspace workspace = WebWorkspace.fromId((String)path.segment(1));
                JSONArray projects = workspace.getProjectsJSON();
                JSONObject result = new JSONObject();
                JSONArray children = new JSONArray();
                int i = 0;
                while (i < projects.length()) {
                    try {
                        JSONObject project = (JSONObject)projects.get(i);
                        WebProject webProject = WebProject.fromId((String)project.getString("Id"));
                        if (this.isAccessAllowed(user, webProject)) {
                            URI contentLocation = URI.create(webProject.getId());
                            Path projectPath = new Path(contentLocation.getPath());
                            Map<IPath, File> gitDirs = GitUtils.getGitDirs((IPath)projectPath, GitUtils.Traverse.GO_DOWN);
                            for (Map.Entry<IPath, File> entry : gitDirs.entrySet()) {
                                JSONObject child = this.toJSON(entry, baseLocation);
                                children.put((Object)child);
                            }
                        }
                    }
                    catch (JSONException jSONException) {}
                    ++i;
                }
                result.put("Children", (Object)children);
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                return true;
            }
            String msg = NLS.bind((String)"Nothing found for the given ID: {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
        }
        if (path.segment(0).equals("file") && path.segmentCount() > 1) {
            WebProject webProject = WebProject.fromId((String)path.segment(1));
            if (this.isAccessAllowed(user, webProject) && webProject.getProjectStore().getFileStore(path.removeFirstSegments(2)).fetchInfo().exists()) {
                URI contentLocation = URI.create(webProject.getId());
                IPath projectPath = new Path(contentLocation.getPath()).append(path.removeFirstSegments(2));
                Map<IPath, File> gitDirs = GitUtils.getGitDirs(projectPath, GitUtils.Traverse.GO_DOWN);
                JSONObject result = new JSONObject();
                JSONArray children = new JSONArray();
                for (Map.Entry<IPath, File> entry : gitDirs.entrySet()) {
                    JSONObject child = this.toJSON(entry, baseLocation);
                    children.put((Object)child);
                }
                result.put("Children", (Object)children);
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                return true;
            }
            String msg = NLS.bind((String)"Nothing found for the given ID: {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
        }
        String msg = NLS.bind((String)"Invalid clone request: {0}", (Object)path);
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
    }

    private boolean handlePut(HttpServletRequest request, HttpServletResponse response, String pathString) throws IOException, JSONException, ServletException, URISyntaxException, CoreException, JGitInternalException, GitAPIException {
        Path path;
        Path path2 = path = pathString == null ? Path.EMPTY : new Path(pathString);
        if (path.segment(0).equals("file") && path.segmentCount() > 1) {
            WebProject webProject = WebProject.fromId((String)path.segment(1));
            if (this.isAccessAllowed(request.getRemoteUser(), webProject)) {
                URI contentLocation = URI.create(webProject.getId());
                IPath projectPath = new Path(contentLocation.getPath()).append(path.removeFirstSegments(2));
                projectPath = path.hasTrailingSeparator() ? projectPath : projectPath.removeLastSegments(1);
                File gitDir = GitUtils.getGitDirs(new Path("file").append(projectPath), GitUtils.Traverse.CURRENT).values().iterator().next();
                JSONObject toCheckout = OrionServlet.readJSONRequest((HttpServletRequest)request);
                JSONArray paths = toCheckout.optJSONArray("Path");
                String branch = toCheckout.optString("Branch");
                if (!(paths != null && paths.length() != 0 || branch != null && !branch.isEmpty())) {
                    String msg = NLS.bind((String)"Either '{0}' or '{1}' should be provided: {2}", (Object[])new Object[]{"Path", "Branch", toCheckout});
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                }
                Git git = new Git((Repository)new FileRepository(gitDir));
                if (paths != null) {
                    CheckoutCommand checkout = git.checkout();
                    int i = 0;
                    while (i < paths.length()) {
                        checkout.addPath(paths.getString(i));
                        ++i;
                    }
                    checkout.call();
                    return true;
                }
                if (branch != null) {
                    CheckoutCommand co = git.checkout();
                    try {
                        co.setName(branch).call();
                        return true;
                    }
                    catch (JGitInternalException e) {
                        if (CheckoutResult.Status.CONFLICTS.equals((Object)co.getResult().getStatus())) {
                            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 409, "Checkout aborted.", (Throwable)e));
                        }
                    }
                    catch (RefNotFoundException e) {
                        String msg = NLS.bind((String)"Branch name not found: {0}", (Object)branch);
                        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, (Throwable)e));
                    }
                }
            } else {
                String msg = NLS.bind((String)"Nothing found for the given ID: {0}", (Object)path);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
            }
        }
        String msg = NLS.bind((String)"Invalid checkout request {0}", (Object)pathString);
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, String pathString) throws IOException, JSONException, ServletException, URISyntaxException, CoreException, JGitInternalException, GitAPIException {
        Path path;
        Path path2 = path = pathString == null ? Path.EMPTY : new Path(pathString);
        if (path.segment(0).equals("file") && path.segmentCount() > 1) {
            WebProject webProject = WebProject.fromId((String)path.segment(1));
            if (this.isAccessAllowed(request.getRemoteUser(), webProject)) {
                URI contentLocation = URI.create(webProject.getId());
                IPath projectPath = new Path(contentLocation.getPath()).append(path.removeFirstSegments(2));
                File gitDir = GitUtils.getGitDirs(new Path("file").append(projectPath), GitUtils.Traverse.CURRENT).values().iterator().next();
                FileRepository repo = new FileRepository(gitDir);
                repo.close();
                FileUtils.delete((File)repo.getWorkTree(), (int)3);
                if (path.segmentCount() == 2) {
                    return this.statusHandler.handleRequest(request, response, (Object)GitCloneHandlerV1.removeProject(request.getRemoteUser(), webProject));
                }
                return true;
            }
            String msg = NLS.bind((String)"Nothing found for the given ID: {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
        }
        String msg = NLS.bind((String)"Invalid delete request {0}", (Object)pathString);
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAccessAllowed(String userName, WebProject webProject) {
        try {
            WebUser webUser = WebUser.fromUserName((String)userName);
            JSONArray workspacesJSON = webUser.getWorkspacesJSON();
            int i = 0;
            block2: while (true) {
                if (i >= workspacesJSON.length()) {
                    return false;
                }
                JSONObject workspace = workspacesJSON.getJSONObject(i);
                String workspaceId = workspace.getString("Id");
                WebWorkspace webWorkspace = WebWorkspace.fromId((String)workspaceId);
                JSONArray projectsJSON = webWorkspace.getProjectsJSON();
                int j = 0;
                while (true) {
                    if (j >= projectsJSON.length()) {
                        ++i;
                        continue block2;
                    }
                    JSONObject project = projectsJSON.getJSONObject(j);
                    String projectId = project.getString("Id");
                    if (projectId.equals(webProject.getId())) {
                        return true;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (JSONException jSONException) {}
        return false;
    }

    static ServerStatus removeProject(String userName, WebProject webProject) {
        try {
            WebUser webUser = WebUser.fromUserName((String)userName);
            JSONArray workspacesJSON = webUser.getWorkspacesJSON();
            int i = 0;
            while (i < workspacesJSON.length()) {
                JSONObject workspace = workspacesJSON.getJSONObject(i);
                String workspaceId = workspace.getString("Id");
                WebWorkspace webWorkspace = WebWorkspace.fromId((String)workspaceId);
                JSONArray projectsJSON = webWorkspace.getProjectsJSON();
                int j = 0;
                while (j < projectsJSON.length()) {
                    JSONObject project = projectsJSON.getJSONObject(j);
                    String projectId = project.getString("Id");
                    if (projectId.equals(webProject.getId())) {
                        webWorkspace.removeProject(webProject);
                        try {
                            WorkspaceResourceHandler.removeProject((WebProject)webProject, (String)userName);
                        }
                        catch (CoreException e) {
                            String msg = NLS.bind((String)"Server content location could not be written: {0}", (Object)Activator.getDefault().getRootLocationURI());
                            return new ServerStatus(4, 500, msg, (Throwable)e);
                        }
                        try {
                            webProject.save();
                            webWorkspace.save();
                        }
                        catch (CoreException e) {
                            String msg = "Error persisting project state";
                            return new ServerStatus(4, 500, msg, (Throwable)e);
                        }
                        return new ServerStatus(0, 200, null, null);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JSONException jSONException) {}
        return new ServerStatus(0, 200, null, null);
    }

    private boolean validateCloneName(String name, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        return true;
    }

    private boolean validateCloneUrl(String url, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (url == null || url.trim().length() == 0) {
            this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Clone URL cannot be empty", null));
            return false;
        }
        try {
            new URIish(url);
        }
        catch (URISyntaxException e) {
            this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, NLS.bind((String)"Invalid clone URL: {0}", (Object)url), (Throwable)e));
            return false;
        }
        return true;
    }

    private JSONObject toJSON(Map.Entry<IPath, File> entry, URI baseLocation) throws URISyntaxException {
        IPath k = entry.getKey();
        JSONObject result = new JSONObject();
        try {
            result.put("Id", (Object)k);
            result.put("Name", (Object)(k.segmentCount() == 1 ? WebProject.fromId((String)k.segment(0)).getName() : k.lastSegment()));
            IPath np = new Path("/gitapi").append("clone").append("file").append(k);
            URI location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("Location", (Object)location);
            np = new Path("file").append(k).makeAbsolute();
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("ContentLocation", (Object)location);
            np = new Path("/gitapi").append("remote").append("file").append(k);
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("RemoteLocation", (Object)location);
            np = new Path("/gitapi").append("config").append("clone").append("file").append(k);
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("ConfigLocation", (Object)location);
            np = new Path("/gitapi").append("commit").append("HEAD").append("file").append(k);
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("HeadLocation", (Object)location);
            np = new Path("/gitapi").append("branch").append("file").append(k);
            location = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), np.toString(), baseLocation.getQuery(), baseLocation.getFragment());
            result.put("BranchLocation", (Object)location);
            try {
                FileBasedConfig config = new FileRepository(entry.getValue()).getConfig();
                String remoteUri = config.getString("remote", "origin", "url");
                if (remoteUri != null) {
                    result.put("GitUrl", (Object)remoteUri);
                }
            }
            catch (IOException iOException) {}
        }
        catch (JSONException jSONException) {}
        return result;
    }

    private void addProjectRights(HttpServletRequest request, HttpServletResponse response, String location) throws ServletException {
        if (location == null) {
            return;
        }
        try {
            String locationPath = URI.create(location).getPath();
            AuthorizationService.addUserRight((String)request.getRemoteUser(), (String)locationPath);
            locationPath = locationPath.endsWith("/") ? String.valueOf(locationPath) + "*" : String.valueOf(locationPath) + "/*";
            AuthorizationService.addUserRight((String)request.getRemoteUser(), (String)locationPath);
        }
        catch (CoreException e) {
            this.statusHandler.handleRequest(request, response, (Object)e.getStatus());
        }
    }
}

