/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.ChangeIdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitCommand
extends GitCommand<RevCommit> {
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private boolean all;
    private List<String> only = new ArrayList<String>();
    private boolean[] onlyProcessed;
    private boolean amend;
    private boolean insertChangeId;
    private List<ObjectId> parents = new LinkedList<ObjectId>();
    private String reflogComment;

    protected CommitCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws NoHeadException, NoMessageException, UnmergedPathException, ConcurrentRefUpdateException, JGitInternalException, WrongRepositoryStateException {
        this.checkCallable();
        RepositoryState state = this.repo.getRepositoryState();
        if (!state.canCommit()) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotCommitOnARepoWithState, state.name()));
        }
        this.processOptions(state);
        try {
            Ref head;
            if (this.all && !this.repo.isBare() && this.repo.getWorkTree() != null) {
                Git git = new Git(this.repo);
                try {
                    git.add().addFilepattern(".").setUpdate(true).call();
                }
                catch (NoFilepatternException e) {
                    throw new JGitInternalException(e.getMessage(), e);
                }
            }
            if ((head = this.repo.getRef("HEAD")) == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            ObjectId headId = this.repo.resolve("HEAD^{commit}");
            if (headId != null) {
                if (this.amend) {
                    RevCommit previousCommit = new RevWalk(this.repo).parseCommit(headId);
                    RevCommit[] p = previousCommit.getParents();
                    for (int i = 0; i < p.length; ++i) {
                        this.parents.add(0, p[i].getId());
                    }
                } else {
                    this.parents.add(0, headId);
                }
            }
            DirCache index = this.repo.lockDirCache();
            try {
                if (!this.only.isEmpty()) {
                    index = this.createTemporaryIndex(headId, index);
                }
                ObjectInserter odi = this.repo.newObjectInserter();
                try {
                    ObjectId indexTreeId = index.writeTree(odi);
                    if (this.insertChangeId) {
                        this.insertChangeId(indexTreeId);
                    }
                    CommitBuilder commit = new CommitBuilder();
                    commit.setCommitter(this.committer);
                    commit.setAuthor(this.author);
                    commit.setMessage(this.message);
                    commit.setParentIds(this.parents);
                    commit.setTreeId(indexTreeId);
                    ObjectId commitId = odi.insert(commit);
                    odi.flush();
                    RevWalk revWalk = new RevWalk(this.repo);
                    try {
                        RevCommit revCommit = revWalk.parseCommit(commitId);
                        RefUpdate ru = this.repo.updateRef("HEAD");
                        ru.setNewObjectId(commitId);
                        if (this.reflogComment != null) {
                            ru.setRefLogMessage(this.reflogComment, false);
                        } else {
                            String prefix = this.amend ? "commit (amend): " : "commit: ";
                            ru.setRefLogMessage(prefix + revCommit.getShortMessage(), false);
                        }
                        ru.setExpectedOldObjectId(headId);
                        RefUpdate.Result rc = ru.forceUpdate();
                        switch (rc) {
                            case NEW: 
                            case FORCED: 
                            case FAST_FORWARD: {
                                this.setCallable(false);
                                if (state == RepositoryState.MERGING_RESOLVED) {
                                    this.repo.writeMergeCommitMsg(null);
                                    this.repo.writeMergeHeads(null);
                                } else if (state == RepositoryState.CHERRY_PICKING_RESOLVED) {
                                    this.repo.writeMergeCommitMsg(null);
                                    this.repo.writeCherryPickHead(null);
                                }
                                RevCommit revCommit2 = revCommit;
                                return revCommit2;
                            }
                            case REJECTED: 
                            case LOCK_FAILURE: {
                                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                            }
                        }
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", commitId.toString(), rc}));
                    }
                    finally {
                        revWalk.release();
                    }
                }
                finally {
                    odi.release();
                }
            }
            finally {
                index.unlock();
            }
        }
        catch (UnmergedPathException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfCommitCommand, e);
        }
    }

    private void insertChangeId(ObjectId treeId) throws IOException {
        ObjectId firstParentId = null;
        if (!this.parents.isEmpty()) {
            firstParentId = this.parents.get(0);
        }
        ObjectId changeId = ChangeIdUtil.computeChangeId(treeId, firstParentId, this.author, this.committer, this.message);
        this.message = ChangeIdUtil.insertId(this.message, changeId);
        if (changeId != null) {
            this.message = this.message.replaceAll("\nChange-Id: I" + ObjectId.zeroId().getName() + "\n", "\nChange-Id: I" + changeId.getName() + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirCache createTemporaryIndex(ObjectId headId, DirCache index) throws IOException {
        ObjectInserter inserter = null;
        DirCacheEditor dcEditor = index.editor();
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder dcBuilder = inCoreIndex.builder();
        this.onlyProcessed = new boolean[this.only.size()];
        boolean emptyCommit = true;
        TreeWalk treeWalk = new TreeWalk(this.repo);
        int dcIdx = treeWalk.addTree(new DirCacheIterator(index));
        int fIdx = treeWalk.addTree(new FileTreeIterator(this.repo));
        int hIdx = -1;
        if (headId != null) {
            hIdx = treeWalk.addTree(new RevWalk(this.repo).parseTree(headId));
        }
        treeWalk.setRecursive(true);
        while (treeWalk.next()) {
            String path = treeWalk.getPathString();
            int pos = this.lookupOnly(path);
            CanonicalTreeParser hTree = null;
            if (hIdx != -1) {
                hTree = treeWalk.getTree(hIdx, CanonicalTreeParser.class);
            }
            if (pos >= 0) {
                boolean tracked;
                DirCacheIterator dcTree = treeWalk.getTree(dcIdx, DirCacheIterator.class);
                FileTreeIterator fTree = treeWalk.getTree(fIdx, FileTreeIterator.class);
                boolean bl = tracked = dcTree != null || hTree != null;
                if (!tracked) break;
                if (fTree != null) {
                    boolean objectExists;
                    final DirCacheEntry dcEntry = new DirCacheEntry(path);
                    long entryLength = fTree.getEntryLength();
                    dcEntry.setLength(entryLength);
                    dcEntry.setLastModified(fTree.getEntryLastModified());
                    dcEntry.setFileMode(fTree.getEntryFileMode());
                    boolean bl2 = objectExists = dcTree != null && fTree.idEqual(dcTree) || hTree != null && fTree.idEqual(hTree);
                    if (objectExists) {
                        dcEntry.setObjectId(fTree.getEntryObjectId());
                    } else if (FileMode.GITLINK.equals(dcEntry.getFileMode())) {
                        dcEntry.copyMetaData(index.getEntry(dcEntry.getPathString()));
                    } else {
                        if (inserter == null) {
                            inserter = this.repo.newObjectInserter();
                        }
                        InputStream inputStream = fTree.openEntryStream();
                        try {
                            dcEntry.setObjectId(inserter.insert(3, entryLength, inputStream));
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    dcEditor.add(new DirCacheEditor.PathEdit(path){

                        public void apply(DirCacheEntry ent) {
                            ent.copyMetaData(dcEntry);
                        }
                    });
                    dcBuilder.add(dcEntry);
                    if (emptyCommit && (hTree == null || !hTree.idEqual(fTree))) {
                        emptyCommit = false;
                    }
                } else {
                    dcEditor.add(new DirCacheEditor.DeletePath(path));
                    if (emptyCommit && hTree != null) {
                        emptyCommit = false;
                    }
                }
                this.onlyProcessed[pos] = true;
                continue;
            }
            if (hTree == null) continue;
            DirCacheEntry dcEntry = new DirCacheEntry(path);
            dcEntry.setObjectId(hTree.getEntryObjectId());
            dcEntry.setFileMode(hTree.getEntryFileMode());
            dcBuilder.add(dcEntry);
        }
        for (int i = 0; i < this.onlyProcessed.length; ++i) {
            if (this.onlyProcessed[i]) continue;
            throw new JGitInternalException(MessageFormat.format(JGitText.get().entryNotFoundByPath, this.only.get(i)));
        }
        if (emptyCommit) {
            throw new JGitInternalException(JGitText.get().emptyCommit);
        }
        dcEditor.commit();
        dcBuilder.finish();
        return inCoreIndex;
    }

    private int lookupOnly(String pathString) {
        int i = 0;
        for (String o : this.only) {
            String p = pathString;
            while (true) {
                if (p.equals(o)) {
                    return i;
                }
                int l = p.lastIndexOf("/");
                if (l < 1) break;
                p = p.substring(0, l);
            }
            ++i;
        }
        return -1;
    }

    private void processOptions(RepositoryState state) throws NoMessageException {
        if (this.committer == null) {
            this.committer = new PersonIdent(this.repo);
        }
        if (this.author == null) {
            this.author = this.committer;
        }
        if (state == RepositoryState.MERGING_RESOLVED) {
            try {
                this.parents = this.repo.readMergeHeads();
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
            }
            if (this.message == null) {
                try {
                    this.message = this.repo.readMergeCommitMsg();
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
                }
            }
        }
        if (this.message == null) {
            throw new NoMessageException(JGitText.get().commitMessageNotSpecified);
        }
    }

    public CommitCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommitCommand setCommitter(PersonIdent committer) {
        this.checkCallable();
        this.committer = committer;
        return this;
    }

    public CommitCommand setCommitter(String name, String email) {
        this.checkCallable();
        return this.setCommitter(new PersonIdent(name, email));
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public CommitCommand setAuthor(PersonIdent author) {
        this.checkCallable();
        this.author = author;
        return this;
    }

    public CommitCommand setAuthor(String name, String email) {
        this.checkCallable();
        return this.setAuthor(new PersonIdent(name, email));
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public CommitCommand setAll(boolean all) {
        this.checkCallable();
        if (!this.only.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--all", "--only"));
        }
        this.all = all;
        return this;
    }

    public CommitCommand setAmend(boolean amend) {
        this.checkCallable();
        this.amend = amend;
        return this;
    }

    public CommitCommand setOnly(String only) {
        String o;
        this.checkCallable();
        if (this.all) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--only", "--all"));
        }
        String string = o = only.endsWith("/") ? only.substring(0, only.length() - 1) : only;
        if (!this.only.contains(o)) {
            this.only.add(o);
        }
        return this;
    }

    public CommitCommand setInsertChangeId(boolean insertChangeId) {
        this.checkCallable();
        this.insertChangeId = insertChangeId;
        return this;
    }

    public CommitCommand setReflogComment(String reflogComment) {
        this.reflogComment = reflogComment;
        return this;
    }
}

