/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin.servlets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    UserHandlerV1(UserServiceHelper userServiceHelper, ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String userPathInfo) throws ServletException {
        if (userPathInfo == null) {
            try {
                switch (UserHandlerV1.getMethod((HttpServletRequest)request)) {
                    case GET: {
                        return this.handleUsersGet(request, response);
                    }
                    case POST: {
                        return request.getParameter("reset") == null ? this.handleUserCreate(request, response) : this.handleUserReset(request, response);
                    }
                }
                return false;
            }
            catch (JSONException e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
            }
            catch (Exception e) {
                throw new ServletException("Error handling users", (Throwable)e);
            }
        }
        String[] userPathInfoParts = userPathInfo.split("\\/", 2);
        if (userPathInfoParts.length > 2 && userPathInfoParts[2].equals("Roles")) {
            return false;
        }
        String userId = userPathInfoParts[1];
        try {
            switch (UserHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleUserGet(request, response, userId);
                }
                case PUT: {
                    return this.handleUserPut(request, response, userId);
                }
                case DELETE: {
                    return this.handleUserDelete(request, response, userId);
                }
            }
            return false;
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
        }
        catch (Exception e) {
            throw new ServletException(NLS.bind((String)"Error handling user: {0}", (Object)userId), (Throwable)e);
        }
    }

    private boolean handleUsersGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, JSONException, CoreException {
        Collection<User> users = this.getUserAdmin().getUsers();
        HashSet<JSONObject> userJSONs = new HashSet<JSONObject>();
        URI location = OrionServlet.getURI((HttpServletRequest)req);
        IOrionUserProfileNode userNode = null;
        for (User user : users) {
            URI userLocation = URIUtil.append((URI)location, (String)user.getUid());
            userNode = this.getUserProfileService().getUserProfileNode(user.getUid(), true).getUserProfileNode("general");
            userJSONs.add(this.formJson(user, userNode, userLocation, req.getContextPath()));
        }
        JSONObject json = new JSONObject();
        json.put("users", userJSONs);
        OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)json);
        return true;
    }

    private boolean handleUserGet(HttpServletRequest req, HttpServletResponse resp, String userId) throws IOException, JSONException, ServletException, CoreException {
        User user = this.getUserAdmin().getUser("uid", userId);
        if (user == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User not found " + userId, null));
        }
        IOrionUserProfileNode userNode = this.getUserProfileService().getUserProfileNode(userId, true).getUserProfileNode("general");
        URI location = OrionServlet.getURI((HttpServletRequest)req);
        OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)this.formJson(user, userNode, location, req.getContextPath()));
        return true;
    }

    private boolean handleUserReset(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String login = req.getParameter("login");
        String password = req.getParameter("password");
        if (login == null || login.length() == 0) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User login not specified.", null));
        }
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        User user = userAdmin.getUser("login", login);
        if (user == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 404, "User " + login + " could not be found.", null));
        }
        if (password == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Provide new password", null));
        }
        user.setPassword(password);
        IStatus status = userAdmin.updateUser(user.getUid(), user);
        if (!status.isOK()) {
            return this.statusHandler.handleRequest(req, resp, (Object)status);
        }
        return true;
    }

    private boolean handleUserCreate(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, JSONException, CoreException {
        String login = req.getParameter("login");
        String name = req.getParameter("Name");
        String password = req.getParameter("password");
        if (login == null || login.length() == 0) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User login not specified.", null));
        }
        if (password == null || password.length() == 0) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Cannot create user with empty password.", null));
        }
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        if (userAdmin.getUser("login", login) != null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User " + login + " already exists.", null));
        }
        User newUser = new User(login, name != null ? name : "", password == null ? "" : password);
        if ((newUser = userAdmin.createUser(newUser)) == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, NLS.bind((String)"Error creating user: {0}", (Object)login), null));
        }
        try {
            AuthorizationService.addUserRight((String)newUser.getUid(), (String)newUser.getLocation());
        }
        catch (CoreException e) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User rights could not be added.", (Throwable)e));
        }
        URI userLocation = URIUtil.append((URI)OrionServlet.getURI((HttpServletRequest)req), (String)newUser.getUid());
        IOrionUserProfileNode userNode = this.getUserProfileService().getUserProfileNode(newUser.getUid(), true).getUserProfileNode("general");
        OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)this.formJson(newUser, userNode, userLocation, req.getContextPath()));
        return true;
    }

    private boolean handleUserPut(HttpServletRequest req, HttpServletResponse resp, String userId) throws ServletException, IOException, CoreException, JSONException {
        IStatus status;
        JSONObject data = OrionServlet.readJSONRequest((HttpServletRequest)req);
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        User user = userAdmin.getUser("uid", userId);
        if (user == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User " + userId + " could not be found.", null));
        }
        if (!(this.isAdmin(req.getRemoteUser()) || !data.has("password") || user.getPassword() == null || data.has("oldPassword") && user.getPassword().equals(data.getString("oldPassword")))) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Invalid old password", null));
        }
        if (data.has("oldPassword") && (!data.has("password") || data.getString("password").length() == 0)) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Password cannot be empty", null));
        }
        if (data.has("login")) {
            user.setLogin(data.getString("login"));
        }
        if (data.has("Name")) {
            user.setName(data.getString("Name"));
        }
        if (data.has("password")) {
            user.setPassword(data.getString("password"));
        }
        if (data.has("properties")) {
            JSONObject propertiesObject = data.getJSONObject("properties");
            Iterator propertyIterator = propertiesObject.keys();
            while (propertyIterator.hasNext()) {
                String propertyKey = (String)propertyIterator.next();
                user.addProperty(propertyKey, propertiesObject.getString(propertyKey));
            }
        }
        if (!(status = userAdmin.updateUser(userId, user)).isOK()) {
            return this.statusHandler.handleRequest(req, resp, (Object)status);
        }
        IOrionUserProfileNode userNode = this.getUserProfileService().getUserProfileNode(userId, true).getUserProfileNode("general");
        if (data.has("GitMail")) {
            userNode.put("GitMail", data.getString("GitMail"), false);
        }
        if (data.has("GitName")) {
            userNode.put("GitName", data.getString("GitName"), false);
        }
        userNode.flush();
        return true;
    }

    private boolean isAdmin(String user) {
        String creators = PreferenceHelper.getString((String)"orion.auth.user.creation", null);
        if (creators != null) {
            String[] admins;
            String[] stringArray = admins = creators.split(",");
            int n = admins.length;
            int n2 = 0;
            while (n2 < n) {
                String admin = stringArray[n2];
                if (admin.equals(user)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean handleUserDelete(HttpServletRequest req, HttpServletResponse resp, String userId) throws ServletException {
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        if (!userAdmin.deleteUser(userAdmin.getUser("uid", userId))) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User " + userId + " could not be found.", null));
        }
        return true;
    }

    private JSONObject formJson(User user, IOrionUserProfileNode userProfile, URI location, String contextPath) throws JSONException, CoreException {
        JSONObject json = new JSONObject();
        json.put("uid", (Object)user.getUid());
        json.put("Location", (Object)location);
        json.put("Name", (Object)user.getName());
        json.put("login", (Object)user.getLogin());
        json.put("hasPassword", user.getPassword() != null);
        JSONObject properties = new JSONObject();
        Enumeration userProperties = user.getProperties().keys();
        while (userProperties.hasMoreElements()) {
            String property = (String)userProperties.nextElement();
            properties.put(property, user.getProperty(property));
        }
        json.put("properties", (Object)properties);
        json.put("LastLogInTimestamp", (Object)userProfile.get("lastlogintimestamp", ""));
        json.put("GitMail", (Object)userProfile.get("GitMail", null));
        json.put("GitName", (Object)userProfile.get("GitName", null));
        JSONArray plugins = new JSONArray();
        try {
            JSONObject plugin = new JSONObject();
            URI result = user.getPassword() == null ? new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), String.valueOf(contextPath) + "/plugins/user/nopasswordProfilePlugin.html", null, null) : new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), String.valueOf(contextPath) + "/plugins/user/userProfilePlugin.html", null, null);
            plugin.put("Url", (Object)result);
            plugins.put((Object)plugin);
        }
        catch (URISyntaxException e) {
            LogHelper.log((Throwable)e);
        }
        json.put("Plugins", (Object)plugins);
        return json;
    }

    private IOrionCredentialsService getUserAdmin() {
        return UserServiceHelper.getDefault().getUserStore();
    }

    private IOrionUserProfileService getUserProfileService() {
        return UserServiceHelper.getDefault().getUserProfileService();
    }
}

