/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.Remote;
import org.eclipse.orion.server.git.objects.RemoteBranch;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitFileDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        String requestPath = String.valueOf(request.getServletPath()) + (request.getPathInfo() == null ? "" : request.getPathInfo());
        Path targetPath = new Path(requestPath);
        if (targetPath.segmentCount() <= 1) {
            return;
        }
        String servlet = request.getServletPath();
        if (!"/file".equals(servlet) && !"/workspace".equals(servlet)) {
            return;
        }
        boolean isWorkspace = "/workspace".equals(servlet);
        try {
            if (isWorkspace && ServletResourceHandler.Method.POST.equals((Object)ServletResourceHandler.Method.fromString((String)request.getMethod()))) {
                String contentLocation = representation.getString("ContentLocation");
                this.initGitRepository(request, (IPath)targetPath, representation);
                this.addGitLinks(request, new URI(contentLocation), representation);
                return;
            }
            if (isWorkspace && ServletResourceHandler.Method.GET.equals((Object)ServletResourceHandler.Method.fromString((String)request.getMethod()))) {
                JSONArray children = representation.optJSONArray("Children");
                if (children != null) {
                    int i = 0;
                    while (i < children.length()) {
                        JSONObject child = children.getJSONObject(i);
                        String location = child.getString("Location");
                        this.addGitLinks(request, new URI(location), child);
                        ++i;
                    }
                }
                return;
            }
            if (!isWorkspace && ServletResourceHandler.Method.GET.equals((Object)ServletResourceHandler.Method.fromString((String)request.getMethod()))) {
                boolean git = false;
                this.addGitLinks(request, resource, representation);
                JSONArray children = representation.optJSONArray("Children");
                if (children != null) {
                    int i = 0;
                    while (i < children.length()) {
                        JSONObject child = children.getJSONObject(i);
                        String location = child.getString("Location");
                        if (git || GitUtils.getGitDir(targetPath.append(child.getString("Name"))) != null) {
                            this.addGitLinks(request, new URI(location), child);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void addGitLinks(HttpServletRequest request, URI location, JSONObject representation) throws URISyntaxException, JSONException, CoreException, IOException {
        File gitDir;
        Path contextPath;
        Path targetPath;
        Path requestPath = targetPath = new Path(location.getPath());
        if (request.getContextPath().length() != 0 && (contextPath = new Path(request.getContextPath())).isPrefixOf((IPath)targetPath)) {
            requestPath = targetPath.removeFirstSegments(contextPath.segmentCount());
        }
        if ((gitDir = GitUtils.getGitDir((IPath)requestPath)) == null) {
            return;
        }
        FileRepository db = new FileRepository(gitDir);
        URI cloneLocation = BaseToCloneConverter.getCloneLocation(location, BaseToCloneConverter.FILE);
        JSONObject gitSection = new JSONObject();
        IPath path = new Path("/gitapi/diff/Default").append((IPath)targetPath);
        URI link = new URI(location.getScheme(), location.getAuthority(), String.valueOf(request.getContextPath()) + path.toString(), null, null);
        gitSection.put("DiffLocation", (Object)link);
        path = new Path("/gitapi/status").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), String.valueOf(request.getContextPath()) + path.toString(), null, null);
        gitSection.put("StatusLocation", (Object)link);
        path = new Path("/gitapi/index").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), String.valueOf(request.getContextPath()) + path.toString(), null, null);
        gitSection.put("IndexLocation", (Object)link);
        path = new Path("/gitapi/commit").append("HEAD").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), String.valueOf(request.getContextPath()) + path.toString(), null, null);
        gitSection.put("HeadLocation", (Object)link);
        path = new Path("/gitapi/commit").append(db.getBranch()).append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), String.valueOf(request.getContextPath()) + path.toString(), null, null);
        gitSection.put("CommitLocation", (Object)link);
        path = new Path("/gitapi/remote").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), String.valueOf(request.getContextPath()) + path.toString(), null, null);
        gitSection.put("RemoteLocation", (Object)link);
        path = new Path("/gitapi/config/clone").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), String.valueOf(request.getContextPath()) + path.toString(), null, null);
        gitSection.put("ConfigLocation", (Object)link);
        Remote defaultRemote = new Remote(cloneLocation, (Repository)db, "origin");
        RemoteBranch defaultRemoteBranch = new RemoteBranch(cloneLocation, (Repository)db, defaultRemote, db.getBranch());
        gitSection.put("DefaultRemoteBranchLocation", (Object)defaultRemoteBranch.getLocation());
        path = new Path("/gitapi/tag").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), String.valueOf(request.getContextPath()) + path.toString(), null, null);
        gitSection.put("TagLocation", (Object)link);
        gitSection.put("CloneLocation", (Object)cloneLocation);
        representation.put("Git", (Object)gitSection);
    }

    private void initGitRepository(HttpServletRequest request, IPath targetPath, JSONObject representation) {
        if (targetPath.segmentCount() != 2 || !"workspace".equals(targetPath.segment(0)) || !ServletResourceHandler.Method.POST.equals((Object)ServletResourceHandler.Method.fromString((String)request.getMethod()))) {
            return;
        }
        String scm = PreferenceHelper.getString((String)"orion.file.defaultSCM", (String)"").toLowerCase();
        if (!"git".equals(scm)) {
            return;
        }
        try {
            IFileStore store = WebProject.fromId((String)representation.optString("Id")).getProjectStore();
            File localFile = store.toLocalFile(0, null);
            File gitDir = GitUtils.getGitDir(localFile);
            if (gitDir == null) {
                gitDir = new File(localFile, ".git");
                FileRepository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).build();
                repo.create();
                Git git = new Git((Repository)repo);
                git.add().addFilepattern(".").call();
                git.commit().setMessage("Initial commit").call();
            }
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }
}

