/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Clone;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.eclipse.osgi.util.NLS;

public class InitJob
extends GitJob {
    private final Clone clone;
    private final String user;
    private final String cloneLocation;

    public InitJob(Clone clone, String user, String cloneLocation) {
        super("Init");
        this.clone = clone;
        this.user = user;
        this.cloneLocation = cloneLocation;
        this.task = this.createTask();
    }

    @Override
    protected TaskInfo createTask() {
        TaskInfo info = this.getTaskService().createTask();
        info.setMessage(NLS.bind((String)"Initializing repository {0}...", (Object)this.clone.getName()));
        this.getTaskService().updateTask(info);
        return info;
    }

    private IStatus doInit() {
        try {
            InitCommand command = new InitCommand();
            File directory = new File(this.clone.getContentLocation());
            command.setDirectory(directory);
            Repository repository = command.call().getRepository();
            Git git = new Git(repository);
            GitCloneHandlerV1.doConfigureClone(git, this.user);
            git.commit().setMessage("Initial commit").call();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (JGitInternalException e) {
            return this.getJGitInternalExceptionStatus(e, "An internal git error initializing git repository.");
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.orion.server.git", "Error initializing git repository", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IStatus result = this.doInit();
            if (result.isOK()) {
                this.task.setResultLocation(this.cloneLocation);
                String message = "Init complete.";
                this.task.setMessage(message);
                result = new Status(0, "org.eclipse.orion.server.git", message);
            }
            this.task.done(result);
            this.updateTask(this.task);
            IStatus iStatus = result;
            return iStatus;
        }
        finally {
            this.cleanUp();
        }
    }
}

